import { useDeleteScans } from "@/components/nmap/scans/queries";
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from '@/components/ui/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';

export default function DeleteNmapScanDialog ({
  ids,
  children,
  open,
  onOpenChange
}: {
  ids: number[];
  children: React.ReactNode;
  open?: boolean;
  onOpenChange?: (open: boolean) => void;
}) {
  const { t } = useTranslation();
  const deleteNmapScan = useDeleteScans();

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle> {ids.length > 1
            ? t('Confirm Nmap Scans Deletion')
            : t('Confirm Nmap Scan Deletion')}
          </AlertDialogTitle>
          <AlertDialogDescription>{ids.length > 1
            ? t('Are you sure you want to delete these Nmap scans? This will also delete all Ndiffs involving these scans.')
            : t('Are you sure you want to delete this Nmap scan? This will also delete all Ndiffs involving this scan.')}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
          <AlertDialogAction onClick={() => deleteNmapScan.mutate(ids)}>
            {t('Delete')}
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
};