import { Tabs, TabsList, TabsContent, TabsTrigger } from "@/components/ui/tabs";
import { Integration } from "@/components/role/types";
import { useSearchParams } from "react-router-dom";
import { useAuth } from "@/contexts/AuthContext";
import { hasPermission } from "@/components/role/utils";
import { ProtectedTab, ProtectedTabsType } from "@/components/role/types";

export default function ProtectedTabs<I extends Integration>({
  integration,
  tabs
}: {
  integration: I;
  tabs: ProtectedTabsType<I>;
}) {

  const { user } = useAuth();
  const [searchParams, setSearchParams] = useSearchParams();

  const canViewTab = (tab: ProtectedTab<I>) => {
    if (!tab.resource) return true;
    return hasPermission(
      user?.role,
      integration,
      tab.resource,
      "get"
    );
  };

  const visibleTabs = tabs.filter(canViewTab);
  const tab = searchParams.get("tab");
  const visibleValues = visibleTabs.map(t => t.value);
  const currentTab = visibleValues.includes(tab || "")
    ? tab || undefined
    : visibleValues[0];

  const handleTabChange = (value: string) => {
    setSearchParams({ tab: value });
  };

  return (
    <Tabs value={currentTab} onValueChange={handleTabChange} className='pt-6'>
      <TabsList>
        {visibleTabs.map((tab) => (
          <TabsTrigger key={tab.value} value={tab.value} className="gap-2">
            <tab.icon className="size-4" />
            {tab.title}
          </TabsTrigger>
        ))}
      </TabsList>
      {visibleTabs.map((tab) => (
        <TabsContent key={tab.value} value={tab.value}>
          {tab.children}
        </TabsContent>
      ))}
    </Tabs>
  );
}
