import { Role } from "@/components/role/types";

export const allDefault: Omit<Role, "id" | "users" | "name"> = {
  type: "custom",
  protected: false,
  flow_source_permissions: {
    sources: ['get', 'post', 'put', 'delete'],
    sourcegroups: ['get', 'post', 'put', 'delete'],
    start_stop_sources: true,
    start_stop_sourcegroups: true,
  },
  suricata_permissions: {
    rules: ['get', 'post', 'put', 'delete'],
    rulesets: ['get', 'post', 'put', 'delete'],
    config: true,
    start_stop_scan: true,
    data: ['get', 'put', 'delete'],
    scan_pcap: true,
    alerts: true,
  },
  wireshark_permissions: {
    pcaps: ['get', 'post', 'delete'],
    ring_buffer: ['get', 'post', 'put'],
    start_stop_capture: true,
    start_stop_ring_buffer: true,
  },
  nmap_permissions: {
    scans: ['get', 'post', 'put', 'delete'],
    scheduled_scans: ['get', 'post', 'put', 'delete'],
    profiles: ['get', 'post', 'put', 'delete'],
    ndiffs: ['get', 'post', 'delete'],
  },
};

export const noneDefault: Omit<Role, "id" | "users" | "name"> = {
  type: "custom",
  protected: false,
  flow_source_permissions: {
    sources: [],
    sourcegroups: [],
    start_stop_sources: false,
    start_stop_sourcegroups: false,
  },
  suricata_permissions: {
    rules: [],
    rulesets: [],
    config: false,
    start_stop_scan: false,
    data: [],
    scan_pcap: false,
    alerts: false,
  },
  wireshark_permissions: {
    pcaps: [],
    ring_buffer: [],
    start_stop_capture: false,
    start_stop_ring_buffer: false,
  },
  nmap_permissions: {
    scans: [],
    scheduled_scans: [],
    profiles: [],
    ndiffs: [],
  },
};