import { User } from "@/components/user/types";
import { LucideIcon } from "lucide-react";
import { ReactNode } from "react"

export type Role = {
  id: number;
  name: string;
  type: string;
  users: User[];
  protected: boolean,
} & IntegrationPermissionsMap;

export type Integration = 'flow_source_permissions' | 'suricata_permissions' | 'wireshark_permissions' | 'nmap_permissions';
export type IntegrationPermissionsMap = {
  flow_source_permissions: FlowSourcePermissions;
  suricata_permissions: SuricataPermissions;
  wireshark_permissions: WiresharkPermissions;
  nmap_permissions: NmapPermissions;
};

export type Crud = 'get' | 'post' | 'put' | 'delete';
type Permissions = Crud[];
type FlowSourcePermissions = {
  sources: Permissions;
  sourcegroups: Permissions;
  start_stop_sources: boolean;
  start_stop_sourcegroups: boolean;
}
type SuricataPermissions = {
  rules: Permissions;
  rulesets: Permissions;
  config: boolean;
  start_stop_scan: boolean;
  data: Permissions;
  alerts: boolean;
  scan_pcap: boolean;
}
type WiresharkPermissions = {
  start_stop_capture: boolean;
  start_stop_ring_buffer: boolean;
  ring_buffer: Permissions;
  pcaps: Permissions;
}
type NmapPermissions = {
  scans: Permissions;
  profiles: Permissions;
  scheduled_scans: Permissions;
  ndiffs: Permissions;
}

type ProtectedTab<I extends Integration = Integration> = {
  value: string;
  icon: LucideIcon;
  title: string;
  children: React.ReactNode;
  resource?: keyof IntegrationPermissionsMap[I];
};

export type ProtectedTabsType<I extends Integration = Integration> = ProtectedTab<I>[];
