import { Crud, Role, Integration, IntegrationPermissionsMap } from "@/components/role/types";
import { noneDefault } from "@/components/role/defaults";

export function isAdmin(role: Role | undefined) {
  return role?.type === 'admin';
}

export function hasPermission<
  I extends Integration,
  R extends keyof IntegrationPermissionsMap[I]
>(
  role: Role | undefined,
  integration: I,
  resource: R,
  operation?: Crud,
) {
  if (role === undefined) return false;
  if (isAdmin(role)) return true;

  const permissions = role[integration][resource];

  if (Array.isArray(permissions)) {
    return permissions.includes(operation);
  }

  if (typeof permissions === 'boolean') {
    return permissions;
  }

  return false;
}

export function hasNoViewPermissions(
  role: Role | undefined,
  integration: string,
): boolean {
  if (role === undefined) return true;
  if (isAdmin(role)) return false;

  const formattedIntegration = `${integration}_permissions`;
  const { type, protected: _, ...permissions} = noneDefault;
  if (!(formattedIntegration in permissions)) {
    return false;
  }

  const typedIntegration = formattedIntegration as Integration;
  const rolePermissions = role[typedIntegration];

  for (const resourceKey in rolePermissions) {
    const resource = resourceKey as keyof IntegrationPermissionsMap[typeof typedIntegration];
    const rolePermission = rolePermissions[resource];

    if (Array.isArray(rolePermission) && (rolePermission as Crud[]).includes('get')) {
      return false;
    }
  }

  return true;
}