import { useDeleteSources } from "@/components/source/queries";
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from '@/components/ui/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';

export default function DeleteSourcesDialog ({
  ids,
  children,
  open,
  onOpenChange
}: {
  ids: number[];
  children?: React.ReactNode;
  open?: boolean;
  onOpenChange?: (open: boolean) => void;
}) {
  const { t } = useTranslation();
  const deleteSources = useDeleteSources();

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      {children && <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>}
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle> {ids.length > 1
            ? t('Confirm Flow Sources Deletion')
            : t('Confirm Flow Source Deletion')}
          </AlertDialogTitle>
          <AlertDialogDescription>{ids.length > 1
            ? t('Are you sure you want to delete these flow sources?')
            : t('Are you sure you want to delete this flow source?')}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
          <AlertDialogAction onClick={() => deleteSources.mutate(ids)}>
            {t('Delete')}
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
};