import { useTranslation } from "react-i18next";
import { QuerySummary } from "../types";
import {
  Table,
  TableBody,
  TableCell,
  TableRow,
} from "@/components/ui/table"
import { Skeleton } from "../../ui/skeleton";

type TableData = {label:string, data:string}

export function QuerySummaryTable(data: QuerySummary){
    const { t } = useTranslation();
    const labelMap: Record<string, string> = {
        total_flows: t('Total Flows'),
        total_bytes: t('Total Bytes'),
        total_packets: t('Total Packets'),
        avg_bps: t('Average Bytes/Packet'),
        avg_pps: t('Average Packets/Second'),
        avg_bpp: t('Average Bits/Packet'),
    }

    const tableData:TableData[] = Object.entries(data).map(([key, value]) => ({
        label: labelMap[key] ?? key,
        data: value.toString(),
    }))

    return (
        <Table>
            <TableBody>
                {tableData.map((row,index) => (
                    <TableRow key={index}>
                        <TableCell>{t(row.label)}</TableCell>
                        <TableCell className="text-right">{row.data}</TableCell>
                    </TableRow>
                ))}
            </TableBody>
        </Table>
    )
}

export function QuerySummarySkeleton(){
    return (
        <Table>
            <TableBody>
                {Array.from({ length: 6 }).map((_, i) => (
                    <TableRow key={i}>
                        <TableCell colSpan={2}>
                            <Skeleton className="w-full h-5" />
                        </TableCell>
                    </TableRow>
                ))}
            </TableBody>
        </Table>
    )
}
