import { useQuery } from '@tanstack/react-query';
import axios, { AxiosError } from '@/lib/axios';
import type { QueryResponse, QueryParam } from "../types";

export function useRunQuery(data: QueryParam | null){
    return useQuery<QueryResponse, AxiosError>({
        queryKey: ["Query", data],
        queryFn: async () => {
            const response = await axios.post(`/api/v1/sources/queries/run`, data);
            return response.data;
        },
        enabled: false,
        retry: (failureCount, error) => {
            if (axios.isAxiosError(error) && error.response?.status === 400) {
                return false;
            }
            return failureCount < 1;
        },
    });
}