import { useTranslation } from "react-i18next";
import { CodeBlockWithCopy } from "@/components/ui/CodeBlockWithCopy";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { useEnvironment } from "@/contexts/EnvironmentContext";

export function SuricataInstall() {
  const { t } = useTranslation();
  const { environment } = useEnvironment();
  let command = "";
  let rhelRPM = null;
  if (environment?.distro?.includes("Red Hat Enterprise Linux")) {
    if (environment?.distro?.includes("10")) 
      rhelRPM = "https://dl.fedoraproject.org/pub/epel/epel-release-latest-10.noarch.rpm";
    else 
      rhelRPM = "https://dl.fedoraproject.org/pub/epel/epel-release-latest-9.noarch.rpm";
  }
  const $permissions = `
# Permissions for NNA to use Suricata
sudo chown -R nna:nnacmd /usr/local/var/log/suricata
sudo chmod -R 770 /usr/local/var/log/suricata

sudo chmod 644 /usr/local/etc/suricata/suricata.yaml

sudo mkdir -p /usr/local/var/lib/suricata/update/sources
sudo chown -R nna:nnacmd /usr/local/var/lib/suricata
sudo chmod -R 2775 /usr/local/var/lib/suricata
sudo setfacl -m d:g:nnacmd:rwx /usr/local/var/lib/suricata
sudo setfacl -m g:nnacmd:rwx /usr/local/var/lib/suricata

sudo chown -R root:nnacmd /usr/local/etc/suricata
sudo chmod -R 770 /usr/local/etc/suricata/suricata.yaml
sudo chmod -R 770 /usr/local/etc/suricata
sudo chmod 640 /usr/local/etc/suricata/*.config

sudo setcap cap_net_admin,cap_net_raw=eip /usr/local/bin/suricata`

  if (environment?.distro?.includes("Red Hat Enterprise Linux")) {
    command = `# Download and extract Suricata
cd /tmp
wget https://www.openinfosecfoundation.org/download/suricata-7.0.11.tar.gz
tar xzvf suricata-7.0.11.tar.gz
cd suricata-7.0.11

# Update package list and install dependencies
sudo dnf -y update
sudo dnf -y install ${rhelRPM ?? "https://dl.fedoraproject.org/pub/epel/epel-release-latest-9.noarch.rpm"}
sudo dnf -y install pcre2-devel
sudo dnf -y install libyaml-devel
sudo dnf -y install jansson-devel
sudo dnf -y install libpcap-devel
sudo dnf -y install rustc cargo
sudo dnf -y install libcap-ng-devel
sudo dnf -y install libunwind-devel
sudo dnf -y install file-devel
sudo dnf -y install lz4-devel

# Configure, build, and install Suricata
./configure
sudo make
sudo make install-full
sudo ldconfig
sudo /usr/local/bin/suricata-update update-sources
${$permissions}`;
  } else if (environment?.distro?.includes("CentOS Stream 9") || environment?.distro?.includes("CentOS Stream 10")) {
    command = `# Download and extract Suricata
cd /tmp
wget https://www.openinfosecfoundation.org/download/suricata-7.0.11.tar.gz
tar xzvf suricata-7.0.11.tar.gz
cd suricata-7.0.11

# Update package list and install dependencies
sudo dnf -y update
sudo dnf config-manager --set-enabled crb
sudo dnf -y install epel-release
sudo dnf -y install pcre2-devel
sudo dnf -y install libyaml-devel
sudo dnf -y install jansson-devel
sudo dnf -y install libpcap-devel
sudo dnf -y install rustc cargo
sudo dnf -y install libcap-ng-devel
sudo dnf -y install libunwind-devel
sudo dnf -y install file-devel
sudo dnf -y install lz4-devel
sudo dnf -y install zlib-devel
sudo pip install pyyaml

# Configure, build, and install Suricata
./configure
sudo make
sudo make install-full
sudo ldconfig
sudo /usr/local/bin/suricata-update update-sources
${$permissions}`;
  } else if (environment?.distro?.includes("Oracle Linux")) {
    command = `# Download and extract Suricata
cd /tmp
wget https://www.openinfosecfoundation.org/download/suricata-7.0.11.tar.gz
tar xzvf suricata-7.0.11.tar.gz
cd suricata-7.0.11

# Update package list and install dependencies
sudo dnf -y update
sudo dnf -y install epel-release
sudo dnf -y install pcre2-devel
sudo dnf -y install libyaml-devel
sudo dnf -y install jansson-devel
sudo dnf -y install libpcap-devel
sudo dnf -y install rustc cargo
sudo dnf -y install libcap-ng-devel
sudo dnf -y install libunwind-devel
sudo dnf -y install file-devel
sudo dnf -y install lz4-devel
sudo pip install pyyaml

# Configure, build, and install Suricata
./configure
sudo make
sudo make install-full
sudo ldconfig
sudo /usr/local/bin/suricata-update update-sources
${$permissions}`;
  } else {
    command = `# Download and extract Suricata
cd /tmp
wget https://www.openinfosecfoundation.org/download/suricata-7.0.11.tar.gz
tar xzvf suricata-7.0.11.tar.gz
cd suricata-7.0.11

# Update package list and install dependencies
sudo apt -y update
sudo apt -y install autoconf automake build-essential cargo \
cbindgen libjansson-dev libpcap-dev libpcre2-dev libtool \
libyaml-dev make pkg-config rustc zlib1g-dev
sudo apt -y install libcap-ng-dev
sudo apt -y install libunwind-dev
sudo apt -y install libmagic-dev
sudo apt -y install liblz4-dev

# Configure, build, and install Suricata
./configure
sudo make
sudo make install-full
sudo ldconfig
sudo /usr/local/bin/suricata-update update-sources
${$permissions}`;
  }

  return (
    <Card className="mt-6 gap-2">
      <CardHeader>
        <CardTitle className="text-xl font-bold ml-3">
          {t(
            "Suricata is not installed on this system"
          )}
        </CardTitle>
      </CardHeader>
      <CardContent>
        <div className="flex pb-2">
          <Card className="w-1/2 m-2">
            <CardHeader>
              <CardTitle className="text-xl font-bold">{t('Description')}</CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-bg mt-2">
                {t("Suricata brings real-time intrusion detection and prevention to your network analysis. By inspecting traffic at the packet level, Suricata can detect exploits, malware, and policy violations as they happen. With detailed alerts and logs, it helps strengthen your defenses and supports faster incident response.")}
              </p>
            </CardContent>
          </Card>
          <Card className="w-1/2 m-2">
            <CardHeader>
              <CardTitle className="text-xl font-bold">{t('Features')}</CardTitle>
            </CardHeader>
            <CardContent>
              <ul className="list-disc pl-6 mt-2">
                <li>{t('Detect malware, exploits, and policy violations in real time.')}</li>
                <li>{t('Cross-reference Suricata packet data with Nmap and Wireshark scans for deeper insights.')}</li>
                <li>{t('Send real-time Suricata alerts to designated recipients via email for immediate awareness.')}</li>
                <li>{t('Support incident response with detailed logs and metadata.')}</li>
                <li>{t('Improve threat visibility alongside flow and packet data.')}</li>
              </ul>
            </CardContent>
          </Card>
        </div>
        <CodeBlockWithCopy>{command}</CodeBlockWithCopy>
      </CardContent>
    </Card>
  );
}