import axios from "@/lib/axios";
import { useQuery } from "@tanstack/react-query";
import { CategoryCount, SeverityCount, SuricataAlert, TopAlerts } from "@/components/suricata/alerts/types";

export function useGetSuricataAlerts(timeperiod: string) {
  return useQuery<SuricataAlert[]>({
    queryKey: ["SuricataAlerts", timeperiod], 
    queryFn: async () => {
      const response = await axios.get("/api/v1/suricata/alerts", {
        params: { period: timeperiod || "last_hour" }, 
      });
      return response.data;
    },
  });
}

export function useGetSuricataDailyAlertsCount(){
  return useQuery<number>({
    queryKey: ["TotalAlerts"],
    queryFn: async () => {
      const response = await axios.get("/api/v1/suricata/alerts/total")
      return response.data;
    },
    refetchInterval: 1 * 60 * 1000,
  })
}

export function useGetCategories() {
  return useQuery<CategoryCount>({
    queryKey: ["CategoryCount"],
    queryFn: async () => {
      const response = await axios.get("/api/v1/suricata/alerts/categories")
      return response.data;
    },
    refetchInterval: 1 * 60 * 1000,
  })
}

export function useGetSeverities() {
  return useQuery<SeverityCount>({
    queryKey: ["SeverityCount"],
    queryFn: async () => {
      const response = await axios.get("/api/v1/suricata/alerts/severities")
      return response.data;
    },
    refetchInterval: 1 * 60 * 1000,
  })
}

export function useGetTopAlerts() {
  return useQuery<TopAlerts>({
    queryKey: ["TopAlerts"],
    queryFn: async () => {
      const response = await axios.get("/api/v1/suricata/alerts/top")
      return response.data;
    },
    refetchInterval: 1 * 60 * 1000,
  })
}