import {
  Card,
  CardContent,
  CardDescription,
  CardFooter,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { Dialog, DialogContent } from "@/components/ui/dialog";
import { Button } from "@/components/ui/button"
import { ScrollArea } from "@/components/ui/scroll-area";
import { useGetReverseDNS, useGetWhois } from "@/components/suricata/data/queries";
import { Skeleton } from "@/components/ui/skeleton";
import { useTranslation } from "react-i18next";

type DataActionPopupProps = {
  description: string;
  ip: string;
  action: string;
  setPopupOpen: (value: null) => void;
};

const whoisNotInstalled = "Whois not downloaded please install whois via your package manager.\n\nFor Debian/Ubuntu: sudo apt install whois\nFor RHEL/CentOS/Oracle: sudo yum install whois";

export function DataActionPopup({description, ip, action, setPopupOpen} : DataActionPopupProps) {
  const { t } = useTranslation();
  if (action === "whois") {
    const { data: whoisText, isLoading } = useGetWhois(ip);
    return (
      <Dialog open={true} onOpenChange={(open) => {
        if (!open) setPopupOpen(null);
      }}>
        <DialogContent className="p-0 border-none bg-transparent [&>button]:hidden">
          <Card className="w-150 gap-2">
            <CardHeader>
              <CardTitle>{t("Whois for ")} {ip}</CardTitle>
              <CardDescription>{description}</CardDescription>
            </CardHeader>
            <CardContent className="bg-sidebar-ring/30 m-2 rounded border border-border/50">
              <ScrollArea className="sm:h-100 lg:h-125 xl:h-150 -mr-5">
                {isLoading ? (
                  <div className="p-4 space-y-2">
                    {[...Array(30)].map((_, i) => (
                      <Skeleton key={i} className={`h-4 w-${Math.floor(Math.random() * 5 + 2)}/6`} />
                    ))}
                  </div>
                ) : (
                  <pre className="whitespace-pre-wrap font-mono text-sm py-2">
                    <span className="hover:cursor-text select-text">
                      {whoisText?.whois ?? whoisNotInstalled}
                    </span>
                  </pre>
                )}
              </ScrollArea>
            </CardContent>
            <CardFooter>
              <Button onClick={() => setPopupOpen(null)}>
                {t("Close")}
              </Button>
            </CardFooter>
          </Card>
        </DialogContent>
      </Dialog>
    );
  }
  if (action === "rdns") {
    const { data: rdnsData, isLoading } = useGetReverseDNS(ip);
    return (
      <Dialog open={true} onOpenChange={(open) => {
        if (!open) setPopupOpen(null);
      }}>
        <DialogContent className="p-0 border-none bg-transparent [&>button]:hidden">
          <Card className="w-150 gap-2">
            <CardHeader>
              <CardTitle>{t("Reverse DNS for ")} { ip }</CardTitle>
              <CardDescription>{description}</CardDescription>
            </CardHeader>
            <CardContent className="bg-sidebar-ring/30 m-2 rounded border border-border/50">
              {isLoading ? (
                <div className="py-2.5">
                    <Skeleton className="h-4 w-5/6" />
                </div>
              ) : (
                <pre className="whitespace-pre-wrap font-mono text-sm py-2">
                  <span className="hover:cursor-text select-text">{rdnsData?.ptr ?? "No PTR record found"}</span>
                </pre>
              )}
            </CardContent>
            <CardFooter>
              <Button onClick={() => setPopupOpen(null)}>
                  {t("Close")}
              </Button>
            </CardFooter>
          </Card>
        </DialogContent>
      </Dialog>
    );
  }
}