import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from "@/components/ui/alert-dialog";
import { useTranslation } from "react-i18next";
import { usePostScanAction } from "@/components/suricata/queries";
import { Button } from "@/components/ui/button";
import { Square } from "lucide-react";
import { useState } from "react";

export default function StopSuricataAlertDialog() {
  const { t } = useTranslation();
  const { mutate: startStopScan, isPending } = usePostScanAction();
  const [open, setOpen] = useState(false);

  return (
    <AlertDialog open={open} onOpenChange={setOpen}>
      <AlertDialogTrigger />
        <Button className="mt-2" onClick={() => {setOpen(true);}}>
          <Square />
        </Button>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle>{t("Stop Suricata")}</AlertDialogTitle>
          <AlertDialogDescription>
            {t("Are you sure you want to stop the Suricata scan?")}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t("Cancel")}</AlertDialogCancel>
          <AlertDialogAction
            onClick={() => {
              startStopScan({ action: "stop" });
              setOpen(false);
            }}
            disabled={isPending}
          >
            {t("Stop")}
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
}
