import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
  DialogFooter,
  DialogClose
} from "@/components/ui/dialog"
import { Button } from "@/components/ui/button"
import { Trash2 } from "lucide-react";
import { useTranslation } from "react-i18next"
import { DialogDescription } from "@radix-ui/react-dialog";
import { Tooltip, TooltipTrigger, TooltipContent } from "@/components/ui/tooltip";
import { useDeleteRuleset } from "@/components/suricata/rules/queries";

export function DeleteRulesetDialog({rulesetName}: {rulesetName: string}) {
  const { t } = useTranslation();
  const {mutate: deleteRuleset} = useDeleteRuleset();
  const handleSubmit = () => {
    deleteRuleset(rulesetName);
  }

  return (
    <Dialog>
      <Tooltip>
        <TooltipTrigger asChild>
          <DialogTrigger asChild>
            <Button size="icon" variant="outline">
              <Trash2 />
            </Button>
          </DialogTrigger>
        </TooltipTrigger>
        <TooltipContent>
          {t("Delete Ruleset File")}
        </TooltipContent>
      </Tooltip>
      <DialogContent>
        <DialogHeader>
          <DialogTitle>{t("Delete Ruleset")}</DialogTitle>
          <DialogDescription className="text-muted-foreground">
            {t("Are you sure you want to delete {{name}}? This action cannot be undone.", {name: rulesetName,})}
          </DialogDescription>
        </DialogHeader>
        <DialogFooter>
          <DialogClose asChild>
            <Button variant="secondary">{t("Cancel")}</Button>
          </DialogClose>
          <DialogClose asChild>
            <Button onClick={handleSubmit}>{t("Delete")}</Button>
          </DialogClose>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  )
}
