import CopyButton from "@/components/ui/CopyButton";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "./card";
import { useTranslation } from "react-i18next";

interface CodeBlockWithCopyProps {
  children: string
}

export function CodeBlockWithCopy({ children }: CodeBlockWithCopyProps) {
  const { t } = useTranslation();
  return (
    <Card className="mx-2">
      <CardHeader className="gap-0">
        <CardTitle className="font-bold text-xl">{t("Installation")}</CardTitle>
        <CardDescription>{t("Copy the commands below to your terminal and run them as root to install the software.")}</CardDescription>
      </CardHeader>
      <CardContent>
        <pre className="p-4 bg-secondary rounded-md relative">
          <div className="absolute right-2 top-2 h-8 px-2">
            <CopyButton  textToCopy={children} />
          </div>
          <code>
            {children}
          </code>
        </pre>
      </CardContent>
    </Card>
  )
}
