import { Column } from "@tanstack/react-table"
import { ChevronDown, ChevronUp, ChevronsUpDown} from "lucide-react"
import { cn } from "@/lib/utils"
import { Button } from "@/components/ui/button"
import { useTranslation } from 'react-i18next';

interface DataTableColumnHeaderProps<TData, TValue>
  extends React.HTMLAttributes<HTMLDivElement> {
  column: Column<TData, TValue>
  title: string
}

export function DataTableColumnHeader<TData, TValue>({
  column,
  title,
  className,
}: DataTableColumnHeaderProps<TData, TValue>) {
  const { t } = useTranslation();

  if (!column.getCanSort()) {
    return <div className={cn(className)}>{title}</div>
  }

  return (
    <div className={cn("flex items-center space-x-2 ml-2", className)}>
      <Button
        type="button"
        variant="ghost"
        size="sm"
        className="-ml-3 h-8"
        onClick={() => {
          const currentSort = column.getIsSorted()
          if (currentSort === "asc") {
            column.toggleSorting(true)
          } else if (currentSort === "desc") {
            column.toggleSorting(false)
          } else {
            column.toggleSorting(false)
          }
        }}
      >
        <span>{t(title)}</span>
        {column.getIsSorted() === "desc" ? (
          <ChevronDown className="h-3.5 w-3.5" />
        ) : column.getIsSorted() === "asc" ? (
          <ChevronUp className="h-3.5 w-3.5" />
        ) : (
          <ChevronsUpDown className="h-3.5 w-3.5" />
        )}
      </Button>
    </div>
  )
}
