import { Table } from "@tanstack/react-table";
import { useTranslation } from "react-i18next";
import { Button } from "@/components/ui/button";
import {
  ChevronLeft,
  ChevronRight,
  ChevronsLeft,
  ChevronsRight,
} from "lucide-react";

interface DataTablePaginationNavProps<TData> {
  table: Table<TData>;
}

export function DataTablePaginationNav<TData>({
  table,
}: DataTablePaginationNavProps<TData>) {
  const { t } = useTranslation();

  return (
    <div className="flex items-center space-x-2">
      <Button
        variant="outline"
        className="hidden h-8 w-8 p-0 lg:flex"
        onClick={() => table.setPageIndex(0)}
        disabled={!table.getCanPreviousPage()}
      >
        <span className="sr-only">{t("Go to first page")}</span>
        <ChevronsLeft />
      </Button>
      <Button
        variant="outline"
        className="h-8 w-8 p-0"
        onClick={() => table.previousPage()}
        disabled={!table.getCanPreviousPage()}
      >
        <span className="sr-only">{t("Go to previous page")}</span>
        <ChevronLeft />
      </Button>
      <div className="flex w-fit items-center justify-center text-sm font-regular text-nowrap">
        {table.getState().pagination.pageIndex + 1} of {table.getPageCount()}
      </div>
      <Button
        variant="outline"
        className="h-8 w-8 m-2 lg:mr-2 p-0 mr-0"
        onClick={() => table.nextPage()}
        disabled={!table.getCanNextPage()}
      >
        <span className="sr-only">{t("Go to next page")}</span>
        <ChevronRight />
      </Button>
      <Button
        variant="outline"
        className="hidden h-8 w-8 p-0 lg:flex"
        onClick={() => table.setPageIndex(table.getPageCount() - 1)}
        disabled={!table.getCanNextPage()}
      >
        <span className="sr-only">{t("Go to last page")}</span>
        <ChevronsRight />
      </Button>
    </div>
  );
}
