import {
    Select,
    SelectContent,
    SelectGroup,
    SelectItem,
    SelectTrigger,
    SelectValue,
} from "@/components/ui/select"
import { useTranslation } from "react-i18next";
import { cn } from "@/lib/utils";

//  TODO hook up default langauge and make a way to dynamically get the languages

export default function LanuageDropdown({ field, defaultValue, onChange, className, children }: any) {
    const { t } = useTranslation();
    const languages: { label: string; value: string }[] = [
        { label: t("Bulgarian"), value: "bg_BG" },
        { label: t("Czech"), value: "cs_CZ" },
        { label: t("German"), value: "de_DE" },
        { label: t("English"), value: "en_US" },
        { label: t("Spanish"), value: "es_ES" },
        { label: t("French"), value: "fr_FR" },
        { label: t("Italian"), value: "it_IT" },
        { label: t("Japanese"), value: "ja_JP" },
        { label: t("Korean"), value: "ko_KR" },
        { label: t("Polish"), value: "pl_PL" },
        { label: t("Portugese"), value: "pt_PT" },
        { label: t("Russian"), value: "ru_RU" },
        { label: t("Chinese (China)"), value: "zh_CN" },
        { label: t("Chinese (Taiwan)"), value: "zh_TW" },
    ];

    return (
        <Select
            defaultValue={field ? field.value : defaultValue || 'en_US'}
            onValueChange={(selectedVal) => {
                field ? field.onChange(selectedVal) : onChange(selectedVal)
            }}
        >
            <SelectTrigger className={cn("w-full", className)}>
                {children}
                <SelectValue placeholder="Select a language" />
            </SelectTrigger>
            <SelectContent>
                <SelectGroup className="max-h-80">
                    {languages.map(({ label, value }) => (
                        <SelectItem key={value} value={value}>
                            {t(label)}
                        </SelectItem>
                    ))}
                </SelectGroup>
            </SelectContent>
        </Select>
    );
}