import {
    Select,
    SelectContent,
    SelectGroup,
    SelectItem,
    SelectTrigger,
    SelectValue,
  } from "@/components/ui/select"
  import { useTranslation } from "react-i18next";

export default function ThemesDropdown({field}: any) {
    const {t} = useTranslation();
    const themes = [
        { label: t("Default"), value: "default" },
        { label: t("Light"), value: "light" },
        { label: t("Dark"), value: "dark" },
    ];

    return(
        <div className="col-span-2 w-full">
            <Select
                value={field.value}
                onValueChange={(selectedVal) => {
                field.onChange(selectedVal)
            }}>
                <SelectTrigger className="w-full">
                    <SelectValue placeholder={t("Select a theme")} />
                </SelectTrigger>
                <SelectContent>
                    <SelectGroup className="w-full max-h-80">
                        {themes.map((theme) => (
                            <SelectItem key={theme.value} value={theme.value}>
                                {theme.label}
                            </SelectItem>
                        ))}
                    </SelectGroup>
                </SelectContent>
            </Select>
        </div>
    );
}