import { ScrollArea } from "@/components/ui/scroll-area";
import { cn } from "@/lib/utils";
import React, { useEffect } from "react";

export function ScrollingContainer({
  containerRef,
  sectionRefs,
  setActiveSection,
  threshold,
  children,
  className,
}: {
  containerRef: React.RefObject<HTMLDivElement | null>;
  sectionRefs: React.RefObject<Record<string, HTMLDivElement | null>>;
  setActiveSection: (fragment: string) => void;
  threshold: number;
  children: React.ReactNode;
  className?: string;
}) {

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            setActiveSection(entry.target.id);
          }
        });
      },
      {
        threshold,
        root: containerRef.current,
        rootMargin: "0px 0px -50% 0px",
      }
    );

    Object.values(sectionRefs.current).forEach((el) => {
      if (el) observer.observe(el);
    });

    return () => {
      Object.values(sectionRefs.current).forEach((el) => {
        if (el) observer.unobserve(el);
      });
    };
  }, []);

  return (
    <ScrollArea className="h-[calc(700px-8rem)]" ref={containerRef}>
      {<div
        className={cn("flex flex-col gap-4 *:scroll-mt-4 px-4", className)}
      >
        {children}
      </div>}
    </ScrollArea>
  );
}
