import * as React from "react"
import * as TabsPrimitive from "@radix-ui/react-tabs"

import { cn } from "@/lib/utils"
import { cva, type VariantProps } from "class-variance-authority"

const tabsListVariants = cva(
  "inline-flex items-center justify-start h-9 space-x-4 text-muted-foreground",
  {
    variants: {
      variant: {
        default:
          "rounded-lg bg-muted p-1 w-min",
        underline:
          "border-b border-border",
      },
    },
    defaultVariants: {
      variant: "default",
    },
  }
)

const TabsTriggerVariants = cva(
  "inline-flex items-center justify-center disabled:opacity-50 whitespace-nowrap text-sm font-normal py-2 transition-all focus-visible:outline-none disabled:pointer-events-none data-[state=active]:shadow data-[state=active]:text-foreground px-3",
  {
    variants: {
      variant: {
        default:
          "data-[state=active]:bg-background data-[state=active]:text-primary ring-offset-background focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 data-[state=active]:shadow disabled:opacity-50 rounded-md py-1",
        underline:
          "border-b border-transparent focus:border-primary ring-0 outline-none shadow-none data-[state=active]:border-primary disabled:opacity-100 rounded-none m-0 pt-1.5 pb-2 hover:bg-background-muted",

      },
    },
    defaultVariants: {
      variant: "default",
    },
  }
)

function Tabs({
  className,
  ...props
}: React.ComponentProps<typeof TabsPrimitive.Root>) {
  return (
    <TabsPrimitive.Root
      data-slot="tabs"
      className={cn("flex flex-col gap-6", className)}
      {...props}
    />
  )
}

function TabsList({
  className,
  variant,
  ...props
}: React.ComponentProps<typeof TabsPrimitive.List> & VariantProps<typeof tabsListVariants>) {
  return (
    <TabsPrimitive.List
      data-slot="tabs-list"
      className={cn(
        tabsListVariants({ variant }),
        className
      )}
      {...props}
/>
  )
}

function TabsTrigger({
  className,
  variant,
  ...props
}: React.ComponentProps<typeof TabsPrimitive.Trigger> & VariantProps<typeof TabsTriggerVariants>) {
  return (
    <TabsPrimitive.Trigger
    data-slot="tabs-trigger"
    className={cn(
    TabsTriggerVariants({ variant }), className)}
    {...props}
/>

  )
}

function TabsContent({
  className,
  ...props
}: React.ComponentProps<typeof TabsPrimitive.Content>) {
  return (
    <TabsPrimitive.Content
      data-slot="tabs-content"
      className={cn("flex-1 outline-none", className)}
      {...props}
    />
  )
}

export { Tabs, TabsList, TabsTrigger, TabsContent }
