import type { PacketSummary } from '@/components/wireshark/types';
import { Table, TableHead, TableBody, TableHeader, TableRow, TableCell } from '@/components/ui/table';
import { Skeleton } from '@/components/ui/skeleton';
import { useTranslation } from 'react-i18next';

export default function PacketSummary({ packetSummary }: { packetSummary: PacketSummary | undefined }) {
  const { t } = useTranslation();

  return (
    <div className="flex flex-col gap-4">
      {
        packetSummary ? (
          <Table>
            <TableHeader>
              <TableRow>
                <TableHead>{t("Field")}</TableHead>
                <TableHead>{t("Value")}</TableHead>
              </TableRow>
            </TableHeader>
            <TableBody>
              <TableRow>
                <TableCell>{t("Source IP")}</TableCell>
                <TableCell>{packetSummary.source}</TableCell>
              </TableRow>
              <TableRow>
                <TableCell>{t("Destination IP")}</TableCell>
                <TableCell>{packetSummary.destination}</TableCell>
              </TableRow>
              <TableRow>
                <TableCell>{t("Source Port")}</TableCell>
                <TableCell>
                  {
                    renderPort(packetSummary.srcPort)
                  }
                </TableCell>
              </TableRow>
              <TableRow>
                <TableCell>{t("Destination Port")}</TableCell>
                <TableCell>
                  {
                    renderPort(packetSummary.dstPort)
                  }
                </TableCell>
              </TableRow>
              <TableRow>
                <TableCell>{t("Protocol")}</TableCell>
                <TableCell>{packetSummary.protocol}</TableCell>
              </TableRow>
              <TableRow>
                <TableCell>{t("Timestamp")}</TableCell>
                <TableCell>{new Date(parseInt(packetSummary.time) * 1000).toLocaleString()}</TableCell>
              </TableRow>
              <TableRow>
                <TableCell>{t("Length")}</TableCell>
                <TableCell>{packetSummary.length}</TableCell>
              </TableRow>
            </TableBody>
          </Table>
        ) : (
          <Skeleton className="h-64 w-full" />
        )
      }
    </div>
  )
}

const renderPort = (port: number | null) => {
  if (port) {
    return port;
  }
  return <div className="text-muted-foreground">
    {`N/A`}
  </div>;
}