import { useDeleteCaptures } from "@/components/wireshark/capturehistory/queries";
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from "@/components/ui/alert-dialog";
import React from "react";
import { useTranslation } from "react-i18next";

export default function DeleteCaptureDialog({
  ids,
  children,
  open,
  onOpenChange,
}: {
  ids: number[];
  children: React.ReactNode;
  open?: boolean;
  onOpenChange?: (open: boolean) => void;
}) {
  const { t } = useTranslation();
  const deleteCaptures = useDeleteCaptures();

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle>
            {ids.length > 1
              ? t("Confirm Captures Deletion")
              : t("Confirm Capture Deletion")}
          </AlertDialogTitle>
          <AlertDialogDescription>
            {ids.length > 1
              ? t("Are you sure you want to delete these captures?")
              : t("Are you sure you want to delete this capture?")}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel disabled={deleteCaptures.isPending}>
            {t("Cancel")}
          </AlertDialogCancel>
          <AlertDialogAction
            onClick={() => deleteCaptures.mutate(ids)}
            disabled={deleteCaptures.isPending}
          >
            {deleteCaptures.isPending ? t("Deleting...") : t("Delete")}
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
}
