export type Packet = {
    frameNumber: number
    time: string
    source: string
    destination: string
    protocol: string
    length: number 
    info: string
}

export type NetworkInterface = {
  id: string;
  name: string;
};


export type WiresharkCapture = {
  id: number;
  file_name: string;
  interface: string;
  started_at: string;
  finished_at: string | null;
  status: string;
  pid: number;
}

export type NestedData = Record<string, unknown> | unknown[];
export type PacketDetail = Record<string, unknown>;