import { useQuery} from '@tanstack/react-query';
import axios, { AxiosError } from '@/lib/axios';
import { WiresharkOverview, WiresharkCapturesOverTime } from './types';

export function useWiresharkOverview() {
  return useQuery<WiresharkOverview, AxiosError>({
    queryKey: ['wiresharkOverview'],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/wireshark/overview`);
      return response.data;
    },
    staleTime: 10000,
  });
}

export function useCapturesOverTime(date?: string) {
  return useQuery<WiresharkCapturesOverTime, AxiosError>({
    queryKey: ['capturesOverTime', date],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/wireshark/captures-over-time`, {
        params: { date },
      });
      return response.data;
    },
    staleTime: 10000,
  });
}