import { useQuery} from '@tanstack/react-query';
import axios, { AxiosError } from '@/lib/axios';

import { PacketDetail, PacketSummary} from '@/components/wireshark/types';

interface PacketDetailsResponse {
  packetsSummary: PacketSummary;
  packetsDetails: PacketDetail[] | string;
}

export function useGetPacketDetails(
  framenumber: number,
  filename?: string
) {
  return useQuery<PacketDetailsResponse, AxiosError>({
    queryKey: ['wiresharkPacketData', framenumber],
    queryFn: async () => {
      const response = await axios.get('/api/v1/wireshark/packet-details', {
        params: { framenumber, filename },
      });
      return response.data;
    },
    enabled: !!framenumber,
  });
}

export function useGetWiresharkVersion() {
  return useQuery<String, AxiosError>({
    queryKey: ['wiresharkVersion'],
    queryFn: async () => {
      const response = await axios.get('/api/v1/wireshark/version');
      return response.data.version;
    },
  });
}