import axios from 'axios';
import type { QueryClient } from '@tanstack/react-query';

export function setupAxiosInterceptors(queryClient: QueryClient) {
  axios.interceptors.response.use(
    (response) => response,
    (error) => {
      // Intercept 401 Unauthorized and 419 Page Expired errors
      if (error.response?.status === 401 || error.response?.status === 419) {
        if (queryClient) {
          // Clear auth state to trigger redirect to login
          queryClient.setQueryData(['auth'], null);
        }
      }
      return Promise.reject(error);
    }
  );
}

export { AxiosError } from 'axios';
export default axios;
