import { StrictMode } from 'react'
import { createRoot } from 'react-dom/client'
import './globals.css'
import App from './App'
import { BrowserRouter } from 'react-router'
import { ThemeProvider } from '@/contexts/ThemeContext'
import { QueryClient, QueryClientProvider } from '@tanstack/react-query';
import { AuthProvider } from '@/contexts/AuthContext';
import { EnvironmentProvider } from '@/contexts/EnvironmentContext';
import { prefetchIntegrations } from './components/queries'
import { LanguageProvider } from './contexts/LanguageContext'
import { setupAxiosInterceptors } from '@/lib/axios'

const queryClient = new QueryClient();
prefetchIntegrations(queryClient);
setupAxiosInterceptors(queryClient);

createRoot(document.getElementById('root')!).render(
  <StrictMode>
    <QueryClientProvider client={queryClient}>
      <EnvironmentProvider>
        <ThemeProvider defaultTheme="dark" storageKey="vite-ui-theme">
          <AuthProvider>
            <LanguageProvider>
              <BrowserRouter>
                <App />
              </BrowserRouter>
            </LanguageProvider>
          </AuthProvider>
        </ThemeProvider>
      </EnvironmentProvider>
    </QueryClientProvider>
  </StrictMode>,
)
