import { useTranslation } from "react-i18next";
import {
    PageLayout,
    PageHeader,
    PageTitle,
    PageDescription,
    PageSeparator,
    PageSectionTitle,
    PageSectionDescription,
} from "@/components/Page";
import LicenseForm from "@/components/administration/license/LicenseForm";
import ActivateLicenseForm from "@/components/administration/license/ActivateLicenseForm";
import { useAuth } from "@/contexts/AuthContext"; 
import TrialForm from "@/components/administration/license/TrialForm";

export default function License() {
  const { t } = useTranslation();
  const { license, isLicenseLoading, isUserLoading } = useAuth();

  if (isUserLoading || isLicenseLoading) return <div>{t("Loading...")}</div>;

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t("License Information")}</PageTitle>
        <PageDescription>
          {t("Update your Nagios Network Analyzer license key. If you do not have one, you can ")}
          <a
            href="https://www.nagios.com/products/nagios-network-analyzer/buy-now/"
            target="_blank"
            className="text-primary underline"
          >
            {t("purchase one")}
          </a>
          .
        </PageDescription>
      </PageHeader>

      <PageSeparator />

      <PageSectionTitle>{t("License Type")}</PageSectionTitle>
      <PageSectionDescription className="mb-4">{t("Choose the type of license you want to use.")}</PageSectionDescription>
      <div className="flex gap-4">
        {license && <TrialForm showBorder={true} />}
        {license && <LicenseForm />}
      </div>

      {license && license.type === "licensed" && !license.activated && (
        <>
          <PageSeparator />
          <PageSectionTitle>{t("License Activation")}</PageSectionTitle>
          <PageSectionDescription className="mb-4">{t("Activate your license to continue using Nagios Network Analyzer.")}</PageSectionDescription>
          <div className="my-4" />
          <ActivateLicenseForm />
        </>
      )}
    </PageLayout>
  );
}