import { PageLayout, PageHeader, PageTitle, PageDescription, PageSeparator } from "@/components/Page";
import { useTranslation } from "react-i18next";
import { useGetRoles } from "@/components/role/queries";
import RolesDataTable from "@/components/role/RolesDataTable";
import { Button } from "@/components/ui/button";
import { Plus } from "lucide-react";
import { AddRoleDialog } from "@/components/role/AddEditRoleDialog";
import { useAuth } from "@/contexts/AuthContext";
import { isAdmin } from "@/components/role/utils";

export default function Roles() {

  const { user } = useAuth();
  const { t } = useTranslation();
  const { data: roles } = useGetRoles();

  if (!roles) return <div></div>
  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t("Roles")}</PageTitle>
        <PageDescription>{t("Manage user roles. The Admin and User roles are protected. User is the default role assigned to users.")}</PageDescription>
      </PageHeader>
      <PageSeparator />
      {isAdmin(user?.role) &&
        <AddRoleDialog>
          <Button className="mb-4">
            <Plus />
            {t("New Role")}
          </Button>
        </AddRoleDialog>
      }
      <RolesDataTable roles={roles} />
    </PageLayout>
  );
}