import { useTranslation } from "react-i18next";
import DashboardDropdown from "@/components/dashboard/DashboardDropdown";
import { ChevronsUpDown, Frown, Plus } from "lucide-react";
import { Button } from "@/components/ui/button";

export default function DashboardNotFound() {

  const { t } = useTranslation();
  
  return (
    <div className="relative flex size-full items-center justify-center duration-300 animate-in fade-in-50 zoom-in-95">
      <div className="relative size-[calc(100%-10rem)] min-h-120 rounded grid grid-rows-3 justify-center items-center place-items-center">
        <svg
          className="absolute inset-0 size-full z-0 stroke-foreground opacity-40 overflow-visible"
          xmlns="http://www.w3.org/2000/svg"
        >
          <rect
            width="100%"
            height="100%"
            fill="none"
            strokeWidth="1"
            strokeDasharray="8,6"
          />
        </svg>
        <Plus className="absolute -right-[11px] -top-[11px]" />
        <Plus className="absolute -left-[11px] -top-[11px]" />
        <Plus className="absolute -right-[11px] -bottom-[11px]" />
        <Plus className="absolute -left-[11px] -bottom-[11px]" />
        <Frown className="size-30 z-10 self-end" />
        <div className="flex flex-col items-center">
          <p className="text-9xl text-bold font-mono z-10">404</p>
          <p>{t("Sorry, we couldn't find that dashboard.")}</p>
        </div>
        <DashboardDropdown className="self-start">
          <Button className="z-10" variant="outline">{t("Manage Dashboards")}<ChevronsUpDown /></Button>
        </DashboardDropdown>
      </div>
    </div>
  )
}