import { useTranslation } from 'react-i18next';
import { PageContainer, PageLayout, PageTitle, PageDescription } from '@/components/Page';

export default function MaintenanceExpired() {
  const { t } = useTranslation();

  return (
    <PageContainer>
      <PageLayout>
        <div className="flex flex-col items-center justify-center">
          <PageTitle className="text-center">{t("Feature Requires Active Maintenance")}</PageTitle>
          <PageDescription>
            <p className="text-center max-w-lg">
              {t("The feature you are trying to use requires active maintenance.")}
            </p>
            <p className="text-center max-w-md">
              {t("Your current maintenance has expired. Please renew your maintenance to continue using all features.")}
            </p>
          </PageDescription>
        </div>
      </PageLayout>
    </PageContainer>
  );
}
