import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageDescription,
} from "@/components/Page"
import { useTranslation } from 'react-i18next';
import { NmapIntegrationUpdatesProvider } from "@/components/nmap/NmapIntegrationUpdatesProvider";
import Scans from "@/components/nmap/scans/Scans";
import Ndiffs from "@/components/nmap/ndiffs/Ndiffs";
import Profiles from "@/components/nmap/profiles/Profiles";
import ScheduledScans from "@/components/nmap/scheduledscans/ScheduledScans";
import { useGetScans } from "@/components/nmap/scans/queries";
import { useGetScheduledScans } from "@/components/nmap/scheduledscans/queries";
import { useGetProfiles } from "@/components/nmap/profiles/queries";
import { useGetNdiffs } from "@/components/nmap/ndiffs/queries";
import { useGetNmapVersion } from "@/components/nmap/queries";
import NmapInstall from "@/components/nmap/NmapInstall";
import Overview from "@/components/nmap/overview/Overview";
import { CalendarSearchIcon, ClipboardListIcon, FileDiffIcon, ScanTextIcon, TextSearchIcon } from "lucide-react";
import { ProtectedTabsType } from "@/components/role/types";
import ProtectedTabs from "@/components/role/ProtectedTabs";

export default function Nmap() {
  const { t } = useTranslation();
  const { data: scansData, isLoading: scansLoading } = useGetScans();
  const { data: scheduledScansData, isLoading: scheduledScansLoading } = useGetScheduledScans();
  const { data: profilesData, isLoading: profilesLoading } = useGetProfiles();
  const { data: ndiffsData, isLoading: ndiffsLoading } = useGetNdiffs();
  const { data: nmapVersion, isLoading: nmapVersionLoading } = useGetNmapVersion();

  const tabs: ProtectedTabsType<'nmap_permissions'> = [
    { value: "overview", icon: ClipboardListIcon, title: t("Overview"), children: <Overview /> },
    { value: "scans", icon: TextSearchIcon, title: t("Scans"), children: <Scans data={scansData} isLoading={scansLoading} />, resource: "scans" },
    { value: "scheduledscans", icon: CalendarSearchIcon, title: t("Scheduled Scans"), children: <ScheduledScans data={scheduledScansData} isLoading={scheduledScansLoading} />, resource: "scheduled_scans" },
    { value: "profiles", icon: ScanTextIcon, title: t("Profiles"), children: <Profiles data={profilesData} isLoading={profilesLoading} />, resource: "profiles" },
    { value: "ndiffs", icon: FileDiffIcon, title: t("Ndiffs"), children: <Ndiffs data={ndiffsData} isLoading={ndiffsLoading} />, resource: "ndiffs" },
  ];

  const nmapNotInstalled = (!nmapVersion || nmapVersion.nmap_version === 'None') && !nmapVersionLoading;

  return (
    <NmapIntegrationUpdatesProvider>
    <PageLayout>
      <PageHeader>
        <PageTitle>Nmap</PageTitle>
        <PageDescription>{t('Run Nmap scan commands, create scan profiles, schedule scans, and create Ndiffs.')}</PageDescription>
      </PageHeader>
      {nmapNotInstalled ? (
        <NmapInstall />
      ) : (
        <ProtectedTabs integration="nmap_permissions" tabs={tabs} />
      )}
    </PageLayout>
    </NmapIntegrationUpdatesProvider>
  )
}