import { PageLayout, PageHeader, PageTitle, PageDescription, PageSeparator } from "@/components/Page";
import { useTranslation } from "react-i18next";
import { useGetReports } from "@/components/report/queries";
import ReportsDataTable from "@/components/report/ReportsDataTable";
import { Button } from "@/components/ui/button";
import { Plus } from "lucide-react";
import { AddReportDialog } from "@/components/report/AddEditReportDialog";
import { useAuth } from "@/contexts/AuthContext";
import { isAdmin } from "@/components/role/utils";

export default function Reports() {

  const { user } = useAuth();
  const { t } = useTranslation();
  const { data: reports } = useGetReports();

  if (!reports) return <div></div>
  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t("Reports")}</PageTitle>
        <PageDescription>{t("Manage scheduled reports.")}</PageDescription>
      </PageHeader>
      <PageSeparator />
      {isAdmin(user?.role) &&
        <AddReportDialog>
          <Button className="mb-4">
            <Plus />
            {t("New Report")}
          </Button>
        </AddReportDialog>
      }
      <ReportsDataTable reports={reports} />
    </PageLayout>
  );
}