import { useParams } from "react-router-dom";
import { PageLayout, PageHeader, PageTitle } from "@/components/Page";
import { useTranslation } from "react-i18next";
import { useGetSourceGroup } from "@/components/sourcegroups/queries";
import { Summary } from "@/components/source/Summary";
import { Queries } from "@/components/source/queries/Queries";
import {
  Tabs,
  TabsContent,
  TabsList,
  TabsTrigger,
} from "@/components/ui/tabs"
import SourcesDataTable from "@/components/source/SourcesDataTable";
import { ClipboardListIcon, FileCodeIcon, NetworkIcon } from "lucide-react";

export default function SourceGroup() {
  const { groupId } = useParams();
  const id = Number(groupId);
  const { t } = useTranslation();
  const { data, isLoading } = useGetSourceGroup(id);

  if (isLoading || !data) {
    return <PageLayout><PageHeader><PageTitle>{t('Loading...')}</PageTitle></PageHeader></PageLayout>;
  }
  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t('Flow Source Group - ' + data.name)}</PageTitle>
        {data.description && (
          <div className="mb-2 text-muted-foreground text-base">
            {data.description}
          </div>
        )}
      </PageHeader>
      <Tabs defaultValue="summary" className="pt-6">
        <TabsList>
          <TabsTrigger value="summary" className="gap-1.5">
            <ClipboardListIcon className="w-4 h-4" />
            {t('Summary')}
          </TabsTrigger>
          <TabsTrigger value="queries" className="gap-1.5">
            <FileCodeIcon className="w-4 h-4" />
            {t('Queries')}
          </TabsTrigger>
          <TabsTrigger value="sources" className="gap-1.5">
            <NetworkIcon className="w-4 h-4" />
            {t('Sources')}
          </TabsTrigger>
        </TabsList>
        <TabsContent value="summary">
          <Summary data={data} isSourceGroup={true} />
        </TabsContent>
        <TabsContent value="queries">
          <Queries src={data.sources} />
        </TabsContent>
        <TabsContent value="sources">
          <SourcesDataTable sources={data.sources || []} isLoading={isLoading} />
        </TabsContent>
      </Tabs>
    </PageLayout>
  );
}