import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageDescription,
} from '@/components/Page';
import { useTranslation } from "react-i18next";
import { WiresharkCapture } from '@/components/wireshark/livecapture/WiresharkCapture';
import CaptureHistoryDataTable from '@/components/wireshark/capturehistory/CaptureHistoryDataTable';
import { WiresharkInstall } from '@/components/wireshark/WiresharkInstall';
import { useGetWiresharkVersion } from '@/components/wireshark/queries';
import Overview from '@/components/wireshark/overview/Overview';
import { ClipboardListIcon, FolderClockIcon, Circle, TvMinimalPlayIcon } from 'lucide-react';
import RingBuffer from '@/components/wireshark/ringbuffer/RingBuffer';
import ProtectedTabs from "@/components/role/ProtectedTabs";
import { ProtectedTabsType } from "@/components/role/types";

export default function Wireshark() {
  const { t } = useTranslation();
  const { data, isLoading } = useGetWiresharkVersion();
  const wiresharkNotInstalled = (!data || data === "None") && !isLoading;
  const tabs: ProtectedTabsType<'wireshark_permissions'> = [
    { value: "overview", icon: ClipboardListIcon, title: t("Overview"), children: <Overview /> },
    { value: "capture", icon: TvMinimalPlayIcon, title: t("Capture"), children: <WiresharkCapture />, resource: "pcaps" },
    { value: "history", icon: FolderClockIcon, title: t("Capture History"), children: <CaptureHistoryDataTable />, resource: "pcaps" },
    { value: "ring_buffer", icon: Circle, title: t("Ring Buffer"), children: <RingBuffer />, resource: "ring_buffer" },
  ];

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>Wireshark</PageTitle>
        <PageDescription>{t('Capture packets on a selected network interface.')}</PageDescription>
      </PageHeader>
      { wiresharkNotInstalled ? (
        <WiresharkInstall/>
      ) : (
        <ProtectedTabs integration="wireshark_permissions" tabs={tabs} />
      )}
    </PageLayout>
  );
}
