import Dashboard from '@/pages/dashboard/Dashboard';
import Sources from '@/pages/sources/Sources';
import Suricata from '@/pages/suricata/Suricata';
import Source from '@/pages/sources/Source';
import SourceGroups from '@/pages/sourcegroups/SourceGroups'
import SourceGroup from '@/pages/sourcegroups/SourceGroup';
import Reports from '@/pages/reports/Reports';
import Alerting from '@/pages/alerting/Alerting';
import Help from '@/pages/help/Help';
import Globals from '@/pages/administration/Globals';
import Notifications from '@/pages/administration/Notifications';
import Users from '@/pages/administration/Users';
import Roles from '@/pages/administration/Roles';
import AuthServers from '@/pages/administration/AuthServers';
import License from '@/pages/administration/License';
import Backup from '@/pages/administration/Backup';
import NotFound from '@/pages/NotFound';
import Install from '@/pages/install/Install';
import Login from '@/pages/login/Login';
import Profile from '@/pages/profile/Profile';
import ForgotPassword from '@/pages/login/ForgotPassword';
import ResetPassword from '@/pages/login/ResetPassword';
import Nmap from '@/pages/nmap/Nmap';
import Example from '@/pages/example/Example';
import Wireshark from '@/pages/wireshark/Wireshark';
import Capture from '@/pages/wireshark/Capture';
import Scan from '@/pages/nmap/Scan';
import Ndiff from '@/pages/nmap/Ndiff';
import Home from '@/pages/home/Home';
import { SuricataDataTable } from '@/components/suricata/data/SuricataDataTable';
import RingBufferViewPackets from '@/components/wireshark/ringbuffer/RIngBufferViewPackets';
import ActivateLicense from '@/pages/activate-license/ActivateLicense';
import MaintenanceExpired from '@/pages/maintenance/MaintenanceExpired';
import Layout from '@/components/Layout';
import MinimalLayout from '@/components/MinimalLayout';
import RouteProtector from '@/components/RouteProtector';
import { RouteObject } from 'react-router-dom';

export type CustomRouteObject = RouteObject & {
  label?: string;
  value?: string;
  category?: string;
  isSearchable?: boolean;
  isIntegration?: boolean;
  adminOnly?: boolean;
  children?: CustomRouteObject[];
};

const routes: CustomRouteObject[] = [
  {
    element: <RouteProtector />,
    children: [
      {
        element: <Layout />,
        children: [
          {
            path: '/',
            element: <Home />,
            category: 'General',
            label: 'Home',
            isSearchable: true,
          },
          {
            path: '/example',
            element: <Example />,
            isSearchable: false,
            adminOnly: true,
          },
          {
            path: '/dashboards/:dashboardId',
            element: <Dashboard />,
            isSearchable: false,
          },
          {
            path: '/sources',
            element: <Sources />,
            category: 'Flow Sources',
            label: 'Flow Sources',
            value: 'Flow Data Sources',
            isSearchable: true,
          },
          {
            path: '/suricata',
            element: <Suricata />,
            category: 'Suricata',
            label: 'Suricata',
            isSearchable: true,
            isIntegration: true,
          },
          {
            path: '/suricata/data',
            element: <SuricataDataTable />,
            isSearchable: false,
            isIntegration: true,
          },
          {
            path: '/sources/:sourceId',
            element: <Source />,
            isSearchable: false,
          },
          {
            path: '/groups',
            element: <SourceGroups />,
            category: 'Flow Source Groups',
            label: 'Flow Source Groups',
            value: 'Flow Data Source Groups',
            isSearchable: true,
          },
          {
            path: '/groups/:groupId',
            element: <SourceGroup />,
            isSearchable: false,
          },
          {
            path: '/reports',
            element: <Reports />,
            category: 'General',
            label: 'Reports',
            isSearchable: true,
          },
          {
            path: '/alerting',
            element: <Alerting />,
            category: 'General',
            label: 'Alerting',
            isSearchable: true,
          },
          {
            path: '/nmap',
            element: <Nmap />,
            category: 'Nmap',
            label: 'Nmap',
            isSearchable: true,
            isIntegration: true,
          },
          {
            path: '/nmap/scan/:scanId',
            element: <Scan />,
            isSearchable: false,
            isIntegration: true,
          },
          {
            path: '/nmap/ndiff/:ndiffId',
            element: <Ndiff />,
            isSearchable: false,
            isIntegration: true,
          },
          {
            path: '/help',
            element: <Help />,
            category: 'General',
            label: 'Help',
            isSearchable: true,
          },
          {
            path: '/admin/globals',
            element: <Globals />,
            category: 'Admin',
            label: 'Global Settings',
            value: 'Admin Global Settings',
            isSearchable: true,
            adminOnly: true,
          },
          {
            path: '/admin/notifications',
            element: <Notifications />,
            category: 'Admin',
            label: 'Notification Settings',
            value: 'Admin Notifications Settings',
            isSearchable: true,
            adminOnly: true,
          },
          {
            path: '/admin/users',
            element: <Users />,
            category: 'Admin',
            label: 'User Management',
            value: 'Admin User Management Settings',
            isSearchable: true,
            adminOnly: true,
          },
          {
            path: '/admin/roles',
            element: <Roles />,
            category: 'Admin',
            label: 'Roles',
            value: 'Admin Role Management',
            isSearchable: true,
            adminOnly: true,
          },
          {
            path: '/admin/auth_servers',
            element: <AuthServers />,
            category: 'Admin',
            label: 'AD / LDAP Integration',
            value: 'Admin AD / LDAP Integration Settings',
            isSearchable: true,
            adminOnly: true,
          },
          {
            path: '/admin/license',
            element: <License />,
            category: 'Admin',
            label: 'License Information',
            value: 'Admin License Information',
            isSearchable: true,
            adminOnly: true,
          },
          {
            path: '/admin/backup',
            element: <Backup />,
            category: 'Admin',
            label: 'System Backup',
            value: 'Admin System Backup',
            isSearchable: true,
            adminOnly: true,
          },
          {
            path: '/profile',
            element: <Profile />,
            category: 'General',
            label: 'My Profile',
            value: 'My Profile Settings',
            isSearchable: true,
          },
          {
            path: '/wireshark',
            element: <Wireshark />,
            category: 'Wireshark',
            label: 'Wireshark',
            isSearchable: true,
            isIntegration: true,
          },
          {
            path: '/wireshark/:captureId',
            element: <Capture />,
            isSearchable: false,
            isIntegration: true,
          },
          {
            path: '/wireshark/ringbuffer',
            element: <RingBufferViewPackets/>,
            category: 'Wireshark',
            label: 'Ring Buffer',
            isSearchable: true,
            isIntegration: true,
          },
          {
            path: '/maintenance',
            element: <MaintenanceExpired />,
            isSearchable: false,
          },
          {
            // Catch-all route for 404 errors
            path: '*',
            element: <NotFound />,
            isSearchable: false,
          }
        ]
      },
      {
        element: <MinimalLayout />,
        children: [
          {
            path: '/install',
            element: <Install />,
            isSearchable: false,
          },
          {
            path: '/login',
            element: <Login />,
            isSearchable: false,
          },
          {
            path: '/activate',
            element: <ActivateLicense />,
            isSearchable: false,
          },
          {
            path: '/forgot_password',
            element: <ForgotPassword />,
            isSearchable: false,
          },
          {
            path: '/reset_password/:token',
            element: <ResetPassword />,
            isSearchable: false,
          },
        ]
      },
    ]
  },
];

export default routes;