#!/bin/bash
TZONE="$1"
if [ -z "$TZONE" ]; then
    echo "Usage: $0 <Timezone>"
    exit 1
fi

if [ ! -f "/usr/share/zoneinfo/$TZONE" ]; then
    echo "Invalid timezone: $TZONE"
    exit 1
fi

timedatectl set-timezone "$TZONE"

echo "System timezone updated to $TZONE"
