#!/usr/bin/php
<?php
//
// Sysstat Subsystem
// Copyright (c) 2017-2018 Nagios Enterprises, LLC. All rights reserved.
//
define('SUBSYSTEM', 1);
require_once(dirname(__FILE__) . '/../html/includes/base.inc.php');

subsys_get_options($default_time = 60);
sysstat_subsys();

function sysstat_subsys() {

    global $max_time;
    $start_time = time();

    // Do update check if necessary
    if (get_option('auto_update_check', 0)) {
        do_update_check();
    }

    while ((time() - $start_time) <= $max_time) {

        get_machine_stats();
        sleep(10);
    }

    set_sysstat_data('sysstat_subsys', SUBSYS_OK);
}

function get_machine_stats() {

    $return_code = 0;

    // GET LOAD INFO
    $cmdline = sprintf("/usr/bin/uptime | sed s/,//g | awk -F'average: ' '{  print $2 }'");
    $output = array();
    exec($cmdline, $output, $return_code);

    $rawload = $output[0];
    $loads = explode(" ", $rawload);
    $load = array(
        "load1" => $loads[0],
        "load5" => $loads[1],
        "load15" => $loads[2]
    );

    log_debug(LOG_TYPE_SYSTEM, "LOAD: " . one_line_print_r($load));

    $sdata = base64_encode(serialize($load));
    set_sysstat_data("sysstat_load", $sdata);

    // GET MEMORY INFO
    $cmdline = sprintf("/usr/bin/free -m | head --lines=2 | tail --lines=1 | awk '{ print $2,$3,$4,$5,$6,$7}'");
    $output = array();
    exec($cmdline, $output, $return_code);

    $rawmem = $output[0];
    $meminfo = explode(" ", $rawmem);
    $mem = array(
        "total" => $meminfo[0],
        "used" => $meminfo[1],
        "free" => $meminfo[2],
        "shared" => $meminfo[3],
        "buffers" => $meminfo[4],
        "cached" => $meminfo[5]
    );

    log_debug(LOG_TYPE_SYSTEM, "MEMORY: " . one_line_print_r($mem));

    $sdata = base64_encode(serialize($mem));
    set_sysstat_data("sysstat_memory", $sdata);

    // GET SWAP INFO
    $cmdline = sprintf("/usr/bin/free -m | tail --lines=1 | awk '{ print $2,$3,$4}'");
    $output = array();
    exec($cmdline, $output, $return_code);

    $rawswap = $output[0];
    $swapinfo = explode(" ", $rawswap);
    $swap = array(
        "total" => $swapinfo[0],
        "used" => $swapinfo[1],
        "free" => $swapinfo[2]
    );

    log_debug(LOG_TYPE_SYSTEM, "SWAP: " . one_line_print_r($swap));
    
    $sdata = base64_encode(serialize($swap));
    set_sysstat_data("sysstat_swap", $sdata);

    // GET IOSTAT INFO
    $cmdline = sprintf("/usr/bin/iostat -c -y 1 1 | awk NF");
    $output = array();
    $iostat_lines = exec($cmdline, $output, $return_code);

    // filter out any whitespace in the row with our cpu data
    // (the line with the cpu data we want should always be at $output[2])
    $stat_line = $output[2];
    $iostatinfo = explode(" ", $stat_line);
    $filtered_iostatinfo = array();
    foreach ($iostatinfo as $iostat_val) {
        if (is_numeric($iostat_val)) {
            $filtered_iostatinfo[] = $iostat_val;
        }
    }

    // generate the iostat array and fallback on zero values if for some reason iostat does not output all the cpu data
    $iostat = array(
        "user" => 0,
        "nice" => 0,
        "system" => 0,
        "iowait" => 0,
        "steal" => 0,
        "idle" => 0
    );
    if (count($filtered_iostatinfo) == 6) {
        $iostat = array(
            "user" => $filtered_iostatinfo[0],
            "nice" => $filtered_iostatinfo[1],
            "system" => $filtered_iostatinfo[2],
            "iowait" => $filtered_iostatinfo[3],
            "steal" => $filtered_iostatinfo[4],
            "idle" => $filtered_iostatinfo[5]
        );
    }

    log_debug(LOG_TYPE_SYSTEM, "IOSTAT: " . one_line_print_r($iostat));

    $sdata = base64_encode(serialize($iostat));
    set_sysstat_data("sysstat_cpustat", $sdata);
}
