<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');

$title = _('About');
child_page($title);

echo well_top_page_header($title);
?>
	<style>
	p { max-width: 60%; }
	</style>
    <div class="loginsplash"></div>

	<p style="margin-top: 10px;">
		Nagios<sup>&reg;</sup> Fusion Copyright &copy; 2025
		<a href="https://www.nagios.com/" target="_blank" rel="noreferrer">Nagios Enterprises, LLC</a>. All rights reserved.
	</p>
    
    <h5 class="ul"><?php echo _('About Nagios Fusion'); ?></h5>
    <p>
    	<?php echo _('Nagios Fusion provides IT operations staff and management with quick, at-a-glance visual indication of how your Nagios Core and Nagios XI servers are performing anywhere across your IT infrastructure. It Allows geographically separated teams to manage individual monitoring servers, while providing central operations staff with access to all servers.'); ?>
    </p>
    <p>
    	<?php echo _('For more information on Nagios Fusion, visit the'); ?> 
    	<a href="https://www.nagios.com/products/nagios-fusion/" target="_blank" rel="noreferrer"><?php echo _('Nagios  product page'); ?></a>.
    </p>


    <h5 class="ul"><?php echo _("License"); ?></h5>
    <p>
    	<?php echo _("Use of Nagios Fusion is subject to acceptance of the"); ?> <a href="license.php"><?php echo _("Nagios Software License Terms and Conditions"); ?></a>
    </p>

    <h5 class="ul"><?php echo _("Contact Us"); ?></h5>
    <p><?php echo _("Have a question or technical problem? Contact us today"); ?>:</p>
    <table class="table table-condensed table-no-border" style="width: auto;">
        <tr>
            <td><?php echo _("Support"); ?>:</td>
            <td><a href="https://support.nagios.com/forum/" target="_blank" rel="noreferrer"><?php echo _("Online Support Forum"); ?></a></td>
        </tr>
        <tr>
            <td style="vertical-align: top;"><?php echo _("Sales"); ?>:</td>
            <td>
                <table>
                    <tr>
                        <td><?php echo _("Phone"); ?>:&nbsp;&nbsp;</td><td>(651) 204-9102</td>
                    </tr>
                        <td><?php echo _("Fax"); ?>:&nbsp;&nbsp;</td><td>(651) 204-9103</td>
                    </tr>
                        <td><?php echo _("Email"); ?>:&nbsp;&nbsp;</td><td>sales@nagios.com</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td valign="top"><?php echo _("Web"); ?>:</td>
            <td><a href="https://www.nagios.com/" target="_blank" rel="noreferrer">www.nagios.com</a></td>
        </tr>
    </table>

    <h5 class="ul"><?php echo _("Credits"); ?></h5>
    <p>
    	<?php echo _("We'd like to thank the many individuals, companies, partners, and customers who have shared their ideas and stories with us and participaged in developing some really great software solutions that have made Nagios Fusion a possibility.  Neither Nagios Enterprises nor Nagios Fusion are necessarily endorsed by any of these parties - we just wanted to list them here as a public way of thanking them for the contributions they've made in various ways."); ?>
    </p>
    <p>
    	<?php echo _("Some particular Open Source projects and development communities we'd like to thank include"); ?>:
    	<br>
    	<?php echo _("The PHP development community, the MySQL and Postgres development communities, the ADODB project team, The Jquery project team and expanded Jquery community, the Silk icon set author at famfamfam.com, the PHPMailer team, the RRDTool project, the Nagios Core project, the Nagios Plugins projects, the PNP project, the Nagvis project, the NagiosQL project, the Vartour Style project, the author of the F*Nagios image pack, and the entire Nagios Community and greater OSS community members who make great OSS solutions a possibility through their tireless contributions. We just wanted to let you know that we think you rock."); ?>
    </p>
    <p>
    	<?php echo _("We'd like to give an extra special thanks to the individual founders and leaders of each OSS project mentioned above. We know that it takes a lot to build something that stands head and shoulders above the competition. Kudos for you to bringing awesomeness into the world."); ?>
    </p>
    <p style="margin-left: 20px;">- The Nagios Enterprises Team</p>
