<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');
block_non_admins();
block_demo(_('Email Settings'));

route_request();
function route_request() {

    $update = grab_request_var('update');
    if (!empty($update))
        update_email_settings();

    show_email_settings();
}

function update_email_settings() {
    
    check_nagios_session_protector();

    if (grab_request_var('cancel', false) !== false)
        return;

    $mail_from = grab_request_var('mail_from', get_option('mail_from'));
    $mail_method = grab_request_var('mail_method', get_option('mail_method'));

    $smtp_host = grab_request_var('smtp_host', get_option('smtp_host'));
    $smtp_port = grab_request_var('smtp_port', get_option('smtp_port'));
    $smtp_username = grab_request_var('smtp_username', get_option('smtp_username'));
    $smtp_password = grab_request_var('smtp_password', get_option('smtp_password'));
    $smtp_security = grab_request_var('smtp_security', get_option('smtp_security'));

    set_option('changed_mail_settings', 1);

    set_option('mail_from', $mail_from);
    set_option('mail_method', $mail_method);

    set_option('smtp_host', $smtp_host);
    set_option('smtp_port', $smtp_port);
    set_option('smtp_username', $smtp_username);
    set_option('smtp_password', $smtp_password);
    set_option('smtp_security', $smtp_security);

    flash_message(_('Mail settings updated.'));
}


function show_email_settings() {

    $mail_from = get_option('mail_from');
    $mail_method = get_option('mail_method');

    $smtp_host = get_option('smtp_host');
    $smtp_port = get_option('smtp_port');
    $smtp_username = get_option('smtp_username');
    $smtp_password = get_option('smtp_password');
    $smtp_security = get_option('smtp_security');

    $mail_methods = array(
        'sendmail' => 'Sendmail',
        'smtp' => 'SMTP',
        );

    $smtp_securities = array(
        'none' => _('None'),
        'tls' => 'TLS',
        'ssl' => 'SSL',
        );

    $title = _('Email Settings');
    child_page($title);

    ?>

<script type="text/javascript">
    $(function() {
        $('#mail_method').change(function() {
            var $mail_method = $(this).val();
            var $smtp_settings = $('#smtp_settings');
            var $sendmail_status = $('#sendmail_status');
            if ($mail_method == 'smtp') {
                $smtp_settings.show();
            } else {
                $smtp_settings.hide();
            }
            if ($mail_method == 'sendmail') {
                $sendmail_status.show();
            } else {
                $sendmail_status.hide();
            }
        }).change();
    });
</script>

<?php echo well_top_page_header($title); ?>
<p><?php echo _('Modify the settings used by your Nagios Fusion system for sending informational messages.'); ?></p>
<p><strong><?php echo _('Note'); ?>:</strong> <?php echo _('Mail messages may fail to be delivered if your Fusion server does not have a valid DNS name.'); ?></p>
<a href="testemail.php" class="btn btn-sm btn-info" style="margin-bottom: 20px"><i class="fa fa-paper-plane"></i> <?php echo _('Send a Test Email') ?></a>

<form method="post"  action="?update"  class="formbuilder" >
    <input name="update"  value="1"  type="hidden"  />
    <div class="formbuilder-div formbuilder" >
        <h5 class="ul" >
            <?php echo _('General Mail Settings'); ?>
        </h5>
        <table class="formbuilder-table formbuilder" >
            <tr>
                <td>
                    <label for="mail_from" >
                        <?php echo _('Send Mail From'); ?>:
                    </label>
                </td>
                <td>
                    <input name="mail_from"  type="text"  id="mail_from"  class="form-control textfield" value="<?php echo encode_html($mail_from); ?>" />
                </td>
            </tr>
            <tr>
                <td>
                    <label for="mail_method" >
                        <?php echo _('Mail Method'); ?>:
                    </label>
                </td>
                <td>
                    <select name="mail_method"  id="mail_method"  class="dropdown form-control" >
                        <?php echo get_options_from_array($mail_methods, $mail_method); ?>
                    </select>
                </td>
            </tr>
        </table>
    </div>
    <div class="formbuilder-div formbuilder" id="sendmail_status">
       <h5 class="ul" >
            <?php echo _('Sendmail Status'); ?>
        </h5>
        <?php 
            if ( !shell_exec('ps -e | grep sendmail')){
                echo ('<p><i class="fa fa-exclamation-circle critical-indicator fa-lg" aria-hidden="true"></i>&nbsp;');
                echo _('Warning: Sendmail is not properly installed or is not currently running');
                echo ('</p>');

            }
            else {
                $sm_status = shell_exec('systemctl is-active sendmail');
                echo ('<p><i class="fa fa-check-circle-o ok-indicator fa-lg" aria-hidden="true"></i>&nbsp;');
                echo _('Sendmail is currently '.$sm_status);
                echo ('</p>');
            }
        ?>
    </div>
    <div class="formbuilder-div formbuilder" id="smtp_settings">
        <h5 class="ul" >
            <?php echo _('SMTP Settings'); ?>
        </h5>
        <table class="formbuilder-table formbuilder" >
            <tr>
                <td>
                    <label for="smtp_host" >
                        <?php echo _('Host'); ?>:
                    </label>
                </td>
                <td>
                    <input name="smtp_host"  type="text"  id="smtp_host"  class="form-control textfield" value="<?php echo encode_html($smtp_host); ?>" />
                </td>
            </tr>
            <tr>
                <td>
                    <label for="smtp_port" >
                        <?php echo _('Port'); ?>:
                    </label>
                </td>
                <td>
                    <input name="smtp_port"  size="5"  type="text"  id="smtp_port"  class="form-control textfield" value="<?php echo encode_html($smtp_port); ?>" />
                </td>
            </tr>
            <tr>
                <td>
                    <label for="smtp_username" >
                        <?php echo _('Username'); ?>:
                    </label>
                </td>
                <td>
                    <input name="smtp_username"  type="text"  id="smtp_username"  class="form-control textfield" value="<?php echo encode_html($smtp_username); ?>" />
                </td>
            </tr>
            <tr>
                <td>
                    <label for="smtp_password" >
                        <?php echo _('Password'); ?>:
                    </label>
                </td>
                <td>
                    <input name="smtp_password"  type="password"  id="smtp_password"  class="form-control textfield" value="<?php echo encode_html($smtp_password); ?>" />
                </td>
            </tr>
            <tr>
                <td>
                    <label for="smtp_security" >
                        <?php echo _('Security'); ?>:
                    </label>
                </td>
                <td>
                    <select name="smtp_security"  id="smtp_security"  class="dropdown form-control" >
                        <?php echo get_options_from_array($smtp_securities, $smtp_security); ?>
                    </select>
                </td>
            </tr>
        </table>
    </div>
    <div class="clear"></div>
    <div class="formbuilder-buttons">
        <input name="submit"  value="<?php echo _('Update Settings'); ?>"  class="btn btn-primary btn-sm"  type="submit"  />
        <input name="cancel"  value="<?php echo _('Cancel'); ?>"  class="btn btn-default btn-sm cancel-validator"  type="submit"  />
    </div>
</form>

    <?php
}
