<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');
block_non_admins();

route_request();
function route_request() {

    $pageopt = get_pageopt();

    // if we chose a multi button, we just redirect the page opt based on the value
    $multi = grab_request_var('multi');
    $valid_multi_values = array('delete');
    if (in_array($multi, $valid_multi_values))
        $pageopt = $multi;

    switch ($pageopt) {

        case 'delete':
            delete_log_entries();
            break;

    }

    show_log();
}

function delete_log_entries()
{
    // error in demo
    demo_error('show_log');

    global $db;

    // Grab all log ids
    $log_ids = grab_request_var('log_id');
    if (empty($log_ids)) {
        return;
    }

    // Clean array values just in case
    $log_ids = array_map('intval', $log_ids);
    $in = implode(',', array_fill(0, count($log_ids), '?'));

    // Remove from DB
    $db->query("DELETE FROM log WHERE log_id IN (".$in.")");
    foreach ($log_ids as $k => $id)
        $db->bind($k+1, $id);
    $db->exec();
}

function show_log() {

    $title = _('Fusion Logs');
    child_page($title);
    echo well_top_page_header($title);
    ?>

    <?php
    $select_statement = "SELECT * FROM log";
    $opts = array(
        'display_footer' => false,
        'table_class' => 'table table-condensed table-hover table-bordered table-striped tablesorter',
        'default_pagination' => array(
            'orderby_column' => 'log_time',
            'orderby_order' => 'DESC'
        ),
        'pre_table_html' => 
            '<script>
                $(function() { 
                    $("#select_all").click(function() { 
                        $("input.log_checkbox").prop("checked", $(this).prop("checked")); 
                    }); 
                    $("input.log_checkbox").closest("tr").click(function(ev) {                        
                        // cancel if click is on an input or on a th
                        if (ev.target.nodeName === "INPUT" || ev.target.nodeName === "TH" || ev.target.nodeName === "IMG" || ev.target.nodeName == "SPAN")
                            return;

                        $(this).find("input.log_checkbox").click();
                    });
                });
            </script>',

        'columns' => array(
            'checkbox' => array(
                'th' => '<input type="checkbox" id="select_all" class="log_checkbox" />',
                'td' => '<input type="checkbox" name="log_id[]" value="%log_id%" class="log_checkbox" />',
                'replace_macros' => true,
                'width' => '16px',
                ),
            'log_time' => array(
            	'th' => _('Timestamp'),
            	'sortable' => true,
                'eval' => 'return convert_timestring_to_local_users_time("%log_time%");',
                'width' => '15%',
            	),
            'level' => array(
                'th' => _('Level'),
                'sortable' => true,
                'eval' =>
                	"switch(%level%) {
                		case 0:  return '';
                		default: return log_level_to_human_readable(%level%);
                	}",
                'width' => '10%',
                ),
            'type' => array(
                'th' => _('Type'),
                'sortable' => true,
                'eval' =>
                	"switch(%type%) {
                		case 0:  return '';
                		default: return log_type_to_human_readable(%type%);
                	}",
                'width' => '10%',
                ),
            'server_id' => array(
                'th' => _('Server'),
                'sortable' => true,
                'eval' =>
                	"switch(%server_id%) {
                		case 0:  return '';
                		default: return get_server_attr('name', %server_id%);
                	}",
                'width' => '15%',
                ),
            'user_id' => array(
                'th' => _('User'),
                'sortable' => true,
                'eval' =>
                	"switch(%user_id%) {
                		case 0:  return '';
                		default: return get_username(%user_id%);
                	}",
                'width' => '10%',
                ),
            'message' => array(
            	'th' => _('Log Message'),
            	'sortable' => true,
            	),
            ),
        'with_selected' => array(
            array(
                'value' => 'delete',
                'title' => _('Delete'),
                'img' => get_icon_url('cross.png'),
                ),
            ),
        );
    echo '<form method="post">';
    echo get_paged_table($select_statement, null, $opts);
    echo '</form>';
}
