<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');
block_non_admins();

admin_main();
function admin_main() {

    $title = _('Administration');

    child_page($title);
    echo well_top_page_header($title);
    ?>
    <p><?php echo _('Manage your Fusion installation with the administrative options available to you in this section. Make sure you complete any setup tasks that are shown in red in the Administrative Tasks section below before using Nagios Fusion.'); ?></p>

    <?php

    global $dashlets;

    $admin_tasks = empty($dashlets['admin_tasks']) ? false : $dashlets['admin_tasks'];
    $fusion_subsys_status = empty($dashlets['fusion_subsys_status']) ? false : $dashlets['fusion_subsys_status'];
    $fused_server_stats = empty($dashlets['fused_server_stats']) ? false : $dashlets['fused_server_stats'];

    if ($admin_tasks) {
        echo '<div style="margin: 30px 40px 20px; float: left;">';
        echo "<h2>{$admin_tasks[DASHLET_TITLE]}</h2>";
        echo get_inline_dashlet_html($admin_tasks);
        echo '</div>';
    } else {
        echo '<p>' . _('It looks as if the Administrative Tasks dashlet was removed. Did your Nagios Fusion installation complete successfully?') . '</p>';
    }

    if ($fused_server_stats) {
        echo '<div style="margin: 30px 40px 20px; float: left; max-width: ' . $fusion_subsys_status[DASHLET_WIDTH] . 'px;">';
        echo "<h2>" . _('Subsys Status') . "</h2>";
        echo get_inline_dashlet_html($fusion_subsys_status);
        echo '</div>';
    } else {
        echo '<p>' . _('It looks as if the Fusion Subsystem Status dashlet was removed. Did your Nagios Fusion installation complete successfully?') . '</p>';
    }

    if ($fused_server_stats) {
        if (count_servers()) {
            echo '<div style="margin: 30px 40px 20px; float: left; max-width: ' . $fused_server_stats[DASHLET_WIDTH] . 'px;">';
            echo "<h2>{$fused_server_stats[DASHLET_TITLE]}</h2>";
            echo get_inline_dashlet_html($fused_server_stats);
            echo '</div>';
        }
    } else {
        echo '<p>' . _('It looks as if the Fused Server Stats dashlet was removed. Did your Nagios Fusion installation complete successfully?') . '</p>';
    }

    echo '<div class="clear"></div>';
}