<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');


profile_main();

function profile_main() {

    $title = _('System Profile');

    child_page($title);
    echo well_top_page_header($title);

    global $dashlets;

    $getting_started = empty($dashlets['getting_started']) ? false : $dashlets['getting_started'];

    ?>

    <script>
        $( document ).ready(function() {
            $('#generateDiagFileBtn').on('click', function(){
                var btnElement = this;
                var origVal = $(btnElement).attr("value");
                $(btnElement).attr("value", "<?php echo _('Generating File. Please wait...') ?>");
                $(btnElement).attr("disabled", "disabled");
                $('#fileGenRunningIndicator').removeClass('hidden');
                $('#errorDisplay').addClass('hidden');

                $.ajax({
                    url: 'download-support-file.php',
                    type: 'GET',
                    xhrFields: {
                        responseType: 'blob'
                    },
                    success: function(response, textStatus, xhr) {
                        var contentType = xhr.getResponseHeader('Content-Type');
                        if (!contentType || !contentType.includes('application/octet-stream')) {
                            profileDownloadError();
                        }
                        else {
                            var blob = response;
                            var link = document.createElement('a');
                            var url = URL.createObjectURL(blob);
                            link.href = url;
                            link.download = 'profile.zip';
                            document.body.appendChild(link);
                            link.click();
                            URL.revokeObjectURL(url);
                            document.body.removeChild(link);
                        }
                    },
                    error: function(xhr, status, error) {
                        profileDownloadError();
                    },
                    complete: function() {
                        $(btnElement).attr("value", origVal);
                        $(btnElement).removeAttr('disabled');
                        $('#fileGenRunningIndicator').addClass('hidden');
                    }
                });

                function profileDownloadError() {
                    $('#errorDisplay').removeClass('hidden');
                }
            });
        });
    </script>

    <div style="width: 500px; float: left;">

    <?php
        echo '<p>' . _('A system profile makes it easier for our support engineers to understand your system and configuration. Including a system profile with your support ticket is always recommended and it reduces the response time for most issues.') . '</p>';
        echo '<p>' . _('Please note: It may take several minutes for the download to start however it should complete within 5 minutes. Please keep this browser window open until the download is complete.') . '</p>';
    ?>
        <input type="button" value="<?php echo _('Download Profile') ?>" id="generateDiagFileBtn">&nbsp;&nbsp;
        <i class="fa fa-refresh fa-spin ok-indicator hidden" id="fileGenRunningIndicator" aria-hidden="true"></i>
        <div class="hidden" id="errorDisplay">
            <p>
                <i class="fa fa-exclamation-circle critical-indicator" id="fileGenRunningIndicator" aria-hidden="true"></i>
                <?php echo _('An error occured while attempting to generate the support file.'); ?>
            </p>

            <p>
                <?php echo _('If these errors continue, please run the following as root on the command line (CLI) of the Nagios Fusion server to generate a fresh diagnostic profile') ?><br>
                <?php echo _('This process may take a few minutes to complete.'); ?>
            
            <pre>
wget -O NFU_DiagnosticProfile.sh https://assets.nagios.com/downloads/support/NFU_DiagnosticProfile.sh
chown root NFU_DiagnosticProfile.sh
chmod 700 NFU_DiagnosticProfile.sh
./NFU_DiagnosticProfile.sh</pre>
            </p>
    </div>
    <br />
    <br />

    </div>

    <?php

    if ($getting_started) {
        echo '<div style="margin: 0 40px 20px; float: left;">';
        echo "<h2>{$getting_started[DASHLET_TITLE]}</h2>";
        echo get_inline_dashlet_html($getting_started);
        echo '</div>';
    }
}