<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');
block_non_admins();
block_demo(_('Proxy Configuration'));

route_request();
function route_request()
{
    $update = grab_request_var('update');
    if (!empty($update)) {
        update_proxy_config();
    }

    show_proxy_config();
}

function update_proxy_config()
{
    check_nagios_session_protector();

    if (grab_request_var('cancel', false) !== false)
        return;

    $use_proxy = intval(grab_request_var("use_proxy"));
    $use_proxy_for_polling = intval(grab_request_var("use_proxy_for_polling"));
    $proxy_address = grab_request_var("proxy_address", get_option('proxy_address'));
    $proxy_port = grab_request_var("proxy_port", get_option('proxy_port'));
    $proxy_auth = grab_request_var("proxy_auth", get_option('proxy_auth'));
    $proxy_tunnel = intval(grab_request_var("proxy_tunnel"));

    set_option('use_proxy', $use_proxy);
    set_option('use_proxy_for_polling', $use_proxy_for_polling);
    set_option('proxy_address', $proxy_address);
    set_option('proxy_port', $proxy_port);
    set_option('proxy_auth', $proxy_auth);
    set_option('proxy_tunnel', $proxy_tunnel);

    flash_message(_('Proxy configuration updated.'));
}

function show_proxy_config()
{
    $title = _('Proxy Configuration');
    child_page($title);
    echo well_top_page_header($title);

    // Proxy options
    $use_proxy = intval(grab_request_var("use_proxy", get_option('use_proxy')));
    $use_proxy_for_polling = intval(grab_request_var("use_proxy_for_polling", get_option('use_proxy_for_polling')));
    $proxy_address = grab_request_var("proxy_address", get_option('proxy_address'));
    $proxy_port = grab_request_var("proxy_port", get_option('proxy_port'));
    $proxy_auth = grab_request_var("proxy_auth", get_option('proxy_auth'));
    $proxy_tunnel = intval(grab_request_var("proxy_tunnel", get_option('proxy_tunnel', 1)));
?>

    <p><?php echo _('Set up the proxy that Nagios Fusion will use when contacting external Nagios servers and websites.'); ?></p>

    <form method="post" action="?update" class="formbuilder">
        <input name="update" value="1" type="hidden">

        <div class="checkbox">
            <label>
                <input type="checkbox" class="checkbox" id="use_proxy" name="use_proxy" value="1" <?php echo is_checked($use_proxy); ?>>
                <?php echo _("Enable proxy (update and maintenance checks, activation from the GUI, and upgrades from the GUI)"); ?>
            </label>
        </div>
        <div class="checkbox">
            <label>
                <input type="checkbox" class="checkbox" id="use_proxy_for_polling" name="use_proxy_for_polling" value="1" <?php echo is_checked($use_proxy_for_polling); ?>>
                <?php echo _("Use proxy for polling fused servers."); ?>
            </label>
        </div>

        <h5 class="ul"><?php echo _("Proxy Settings"); ?></h5>

        <table class="table table-no-border table-condensed table-auto-width">
            <tr>
                <td><label for="proxy_address"><?php echo _("Proxy Address"); ?>:</label></td>
                <td>
                    <input type="text" size="45" name="proxy_address" id="proxy_address" value="<?php echo encode_html($proxy_address); ?>" class="textfield form-control">
                </td>
            </tr>
            <tr>
                <td><label for="adminNameBox"><?php echo _("Proxy Port"); ?>:</label></td>
                <td>
                    <input type="text" size="4" name="proxy_port" id="proxy_port" value="<?php echo encode_html($proxy_port); ?>" class="textfield form-control">
                </td>
            </tr>
            <tr>
                <td><label for="proxy_auth"><?php echo _("Proxy Auth"); ?>:</td>
                <td>
                    <input type="text" size="30" name="proxy_auth" id="proxy_auth" value="<?php echo encode_html($proxy_auth); ?>" class="textfield form-control" placeholder="username:password">
                </td>
            </tr>
            <tr>
                <td></td>
                <td class="checkbox">
                    <label>
                        <input type="checkbox" class="checkbox" id="proxy_tunnel" name="proxy_tunnel" value="1" <?php echo is_checked($proxy_tunnel); ?>>
                        <?php echo _("Use HTTP tunnel"); ?>
                    </label>
                </td>
            </tr>
        </table>

        <div class="clear"></div>
        <div class="formbuilder-buttons">
            <input name="submit" value="<?php echo _('Update Settings'); ?>" class="btn btn-primary btn-sm" type="submit">
            <input name="cancel" value="<?php echo _('Cancel'); ?>" class="btn btn-default btn-sm cancel-validator" type="submit">
        </div>

    </form>

<?php
}