<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');
block_non_admins();

route_request();
function route_request() {

    $update = grab_request_var('update');
    if (!empty($update))
        update_settings();

    show_settings();
}

function update_settings() {

    if (grab_request_var('cancel', false) !== false)
        return;

    $internal_url = get_option('internal_url');
    $internal_url = grab_request_var('internal_url', $internal_url);
    $iurl_change = ($internal_url != get_option('internal_url')) ? true : false;

    $public_url = get_option('public_url');
    $public_url = grab_request_var('public_url', $public_url);

    $admin_name = get_option('admin_name');
    $admin_name = grab_request_var('admin_name', $admin_name);

    $admin_email = get_option('admin_email');
    $admin_email = grab_request_var('admin_email', $admin_email);

    $default_language = get_option('default_language', DEFAULT_LANGUAGE);
    $default_language = grab_request_var('default_language', $default_language);

    $auth_interval = get_option('auth_interval', DEFAULT_AUTH_INTERVAL);
    $auth_interval = intval(grab_request_var('auth_interval', $auth_interval));

    $polling_interval = get_option('polling_interval', DEFAULT_POLLING_INTERVAL);
    $polling_interval = intval(grab_request_var('polling_interval', $polling_interval));

    $log_retention = get_option('log_retention', DEFAULT_LOG_RETENTION);
    $log_retention = (float) grab_request_var('log_retention', $log_retention);

    $polled_retention = get_option('polled_retention', DEFAULT_POLLED_RETENTION);
    $polled_retention = (float) grab_request_var('polled_retention', $polled_retention);

    $poll_subsys_memory_limit = get_option('poll_subsys_memory_limit', false);
    $poll_subsys_memory_limit = grab_request_var('poll_subsys_memory_limit', $poll_subsys_memory_limit);

    $only_poll_logged_in = get_option('poll_subsys_memory_limit', 0);
    $only_poll_logged_in = intval(grab_request_var('only_poll_logged_in', $only_poll_logged_in));

    $simultaneous_pollers = get_option('simultaneous_pollers', DEFAULT_SIMULTANEOUS_POLLERS);
    $simultaneous_pollers = intval(grab_request_var('simultaneous_pollers', $simultaneous_pollers));

    $live_data_timeout = get_option('live_data_timeout', DEFAULT_LIVE_DATA_TIMEOUT);
    $live_data_timeout = intval(grab_request_var('live_data_timeout', $live_data_timeout));

    $polling_lock_stale_threshhold = get_option('polling_lock_stale_threshhold', DEFAULT_POLLING_LOCK_STALE_THRESHOLD);
    $polling_lock_stale_threshhold = intval(grab_request_var('polling_lock_stale_threshhold', $polling_lock_stale_threshhold));

    $poll_record_count = get_option('poll_record_count', DEFAULT_POLL_RECORD_COUNT);
    $poll_record_count = intval(grab_request_var('poll_record_count', $poll_record_count));

    $log_level = get_option('log_level');
    $log_level = intval(grab_request_var('log_level', $log_level));

    // Check boxes need to be set to 'blank' if they don't get passed... not set to the current setting
    $write_log = intval(grab_request_var('write_log'));
    $write_debug = intval(grab_request_var('write_debug'));
    $debug_in_db = intval(grab_request_var('debug_in_db'));
    $auto_update_check = intval(grab_request_var('auto_update_check'));

    $log_file = get_option('log_file', DEFAULT_LOG_FILE);
    $log_file = grab_request_var('log_file', $log_file);

    $debug_file = get_option('debug_file', DEFAULT_DEBUG_FILE);
    $debug_file = grab_request_var('debug_file', $debug_file);

    // New user email template
    $user_new_account_email_subject = grab_request_var('user_new_account_email_subject', '');
    $user_new_account_email_body = grab_request_var('user_new_account_email_body', '');

    // Two factor auth (email)
    $two_factor_auth = grab_request_var('two_factor_auth', 0);
    $two_factor_timeout = grab_request_var('two_factor_timeout', 15);
    $two_factor_cookie = grab_request_var('two_factor_cookie', 0);
    $two_factor_cookie_timeout = grab_request_var('two_factor_cookie_timeout', 90);

    $timezone = grab_request_var('timezone', date_default_timezone_get());
    
    $old_theme = get_option('theme', '');
    $theme = grab_request_var('theme', DEFAULT_THEME);

    // no changes in demo
    demo_error('show_settings');

    // check values are valid
    $errmsg = '';
    if (empty($internal_url))
        $errmsg .= _('Internal Url cannot be left blank.') . '<br>';
    if (empty($two_factor_timeout) || ($two_factor_timeout < 0))
        $errmsg .= _('Invalid Two Factor Token Timeout value.') . '<br>';
    if (empty($two_factor_cookie_timeout) || ($two_factor_cookie_timeout < 0))
        $errmsg .= _('Invalid Two Factor Cookie Timeout value.') . '<br>';
    if (empty($auth_interval) || ($auth_interval < 0))
        $errmsg .= _('Invalid Authentication Interval value.') . '<br>';
    if (empty($polling_interval) || ($polling_interval < 0))
        $errmsg .= _('Invalid Polling Interval value.') . '<br>';
    if (!empty($poll_subsys_memory_limit) && (!is_numeric($poll_subsys_memory_limit)  || ($poll_subsys_memory_limit < -1)))
        $errmsg .= _('Invalid Polling Subsystem Memory Limit value.') . '<br>';
    if (empty($simultaneous_pollers) || ($simultaneous_pollers < 0))
        $errmsg .= _('Invalid Simultaneous Pollers value.'. '<br>');
    if (empty($live_data_timeout) || ($live_data_timeout < 0))
        $errmsg .= _('Invalid Live Data Timout value.') . '<br>';
    if (empty($polling_lock_stale_threshhold) || ($polling_lock_stale_threshhold < 0))
        $errmsg .= _('Invalid Polling Lock Max Age value.') . '<br>';
    if (empty($poll_record_count) || ($poll_record_count < 0))
        $errmsg .= _('Invalid Poll Record Count value.') . '<br>';
    if (empty($log_retention) || ($log_retention < 0))
        $errmsg .= _('Invalid Log Data Retention value.') . '<br>';


    if (!empty($errmsg)) {
        flash_message($errmsg, 'error');
        return $reload;
    }

    set_option('changed_program_settings', 1);
    
    set_option('internal_url', $internal_url);
    set_option('public_url', $public_url);
    set_option('admin_name', $admin_name);
    set_option('admin_email', $admin_email);
    set_option('auto_update_check', $auto_update_check);
    set_option('default_language', $default_language);

    set_option('auth_interval', $auth_interval);
    set_option('polling_interval', $polling_interval);
    set_option('log_retention', $log_retention);
    set_option('polled_retention', $polled_retention);

    if ($poll_subsys_memory_limit !== false)
        set_option('poll_subsys_memory_limit', $poll_subsys_memory_limit);

    set_option('only_poll_logged_in', $only_poll_logged_in);
    set_option('simultaneous_pollers', $simultaneous_pollers);
    set_option('live_data_timeout', $live_data_timeout);
    set_option('polling_lock_stale_threshhold', $polling_lock_stale_threshhold);
    set_option('poll_record_count', $poll_record_count);

    set_option('log_level', $log_level);
    set_option('write_log', $write_log);
    set_option('write_debug', $write_debug);
    set_option('debug_in_db', $debug_in_db);
    set_option('log_file', $log_file);
    set_option('debug_file', $debug_file);

    // Set new user email template
    set_option('user_new_account_email_subject', $user_new_account_email_subject);
    set_option('user_new_account_email_body', $user_new_account_email_body);

    // Set two factor authentication (email) options

    $current_two_factor_auth = get_option('two_factor_auth', 0);
    if ($current_two_factor_auth == 0 && $two_factor_auth == 1) {
        // delete all existing sessions only when enabling 2FA, forcing users to login again using 2FA :)
        delete_active_sessions();
    }
    
    set_option('two_factor_auth', $two_factor_auth);
    set_option('two_factor_timeout', $two_factor_timeout);
    set_option('two_factor_cookie', $two_factor_cookie);
    set_option('two_factor_cookie_timeout', $two_factor_cookie_timeout);
    
    set_option('theme', $theme);
    
    update_timezone($timezone);
    
    if ($iurl_change){
        // give warning for users who have changed the internal url
        flash_message(_('Settings Updated! ').
                    "<b>"._("WARNING: Changing the internal URL does not change other URLs. ").
                    _('Please ensure that the server is licensed and View URLs are updated as necessary.')."</b>");
    }
    else{
        flash_message(_('Settings Updated!'));
    }
    
    
    
    if ($old_theme != $theme) {
        $_SESSION['reset_frame'] = 1;
        flash_message(_('System settings updated. (Screen may flash once while UI theme changes)'));
    }
}


function show_settings() {
    
    $reset = 0;
    if (array_key_exists('reset_frame', $_SESSION)) {
        $reset = $_SESSION['reset_frame'];
        unset($_SESSION['reset_frame']);
    }
    
    $internal_url = encode_html(get_option('internal_url'));
    $public_url = encode_html(get_option('public_url'));
    $admin_name = encode_html(get_option('admin_name'));
    $admin_email = encode_html(get_option('admin_email'));
    $auto_update_check = intval(get_option('auto_update_check'));
    $default_language = encode_html(get_option('default_language', DEFAULT_LANGUAGE));

    $auth_interval = intval(get_option('auth_interval', DEFAULT_AUTH_INTERVAL));
    $polling_interval = intval(get_option('polling_interval', DEFAULT_POLLING_INTERVAL));
    $log_retention = (float) get_option('log_retention', DEFAULT_LOG_RETENTION);
    $polled_retention = (float) get_option('polled_retention', DEFAULT_POLLED_RETENTION);

    $only_poll_logged_in = intval(get_option('only_poll_logged_in', 0));
    $poll_subsys_memory_limit = encode_html(get_option('poll_subsys_memory_limit', ''));
    $simultaneous_pollers = intval(get_option('simultaneous_pollers', DEFAULT_SIMULTANEOUS_POLLERS));
    $live_data_timeout = intval(get_option('live_data_timeout', DEFAULT_LIVE_DATA_TIMEOUT));
    $polling_lock_stale_threshhold = intval(get_option('polling_lock_stale_threshhold', DEFAULT_POLLING_LOCK_STALE_THRESHOLD));
    $poll_record_count = intval(get_option('poll_record_count', DEFAULT_POLL_RECORD_COUNT));

    $log_level = intval(get_option('log_level'));
    $write_log = intval(get_option('write_log'));
    $write_debug = intval(get_option('write_debug'));
    $debug_in_db = intval(get_option('debug_in_db'));
    $log_file = encode_html(get_option('log_file', DEFAULT_LOG_FILE));
    $debug_file = encode_html(get_option('debug_file', DEFAULT_DEBUG_FILE));

    get_timezones_and_selected($timezones, $timezone);
    $timezone = encode_html(grab_request_var('timezone', $timezone));
    
    get_themes_and_system_selected($themes, $theme);
    $theme = encode_html(grab_request_var('theme', $theme));

    $log_levels = array(
        LOG_LEVEL_DISABLED => log_level_to_human_readable(LOG_LEVEL_DISABLED),
        LOG_LEVEL_ERROR    => log_level_to_human_readable(LOG_LEVEL_ERROR), 
        LOG_LEVEL_WARN     => log_level_to_human_readable(LOG_LEVEL_WARN), 
        LOG_LEVEL_INFO     => log_level_to_human_readable(LOG_LEVEL_INFO), 
        LOG_LEVEL_DEBUG    => log_level_to_human_readable(LOG_LEVEL_DEBUG), 
        LOG_LEVEL_TRACE    => log_level_to_human_readable(LOG_LEVEL_TRACE),
    );

    // User email template
    $default_email_subject = _("Nagios Fusion Account Created");
    $default_email_body = _("An account has been created for you to access Nagios Fusion. You can login using the following information:\n\nUsername: %username%\nPassword: %password%\nURL: %url%\n\n");
    $user_new_account_email_subject = grab_request_var('user_new_account_email_subject', get_option('user_new_account_email_subject', $default_email_subject));
    $user_new_account_email_body = grab_request_var('user_new_account_email_body', get_option('user_new_account_email_body', $default_email_body));

    // Two Factor Authentication (Email) 
    $two_factor_auth = grab_request_var('two_factor_auth', get_option('two_factor_auth', 0));
    $two_factor_timeout = grab_request_var('two_factor_timeout', get_option('two_factor_timeout', 15));
    $two_factor_cookie = grab_request_var('two_factor_cookie', get_option('two_factor_cookie', 0));
    $two_factor_cookie_timeout = grab_request_var('two_factor_cookie_timeout', get_option('two_factor_cookie_timeout', 90));

    $title = _('System Settings');
    child_page($title);
    echo well_top_page_header($title);
    
    if ($reset) {
        // Flash the next flash message
        flash_message(_('System settings updated.'));
    }
?>
<form method="post"  action="?update"  class="formbuilder" >
<script type="text/javascript">
    <?php if ($reset) { ?>
        window.parent.location.href="<?php echo get_base_url(); ?>admin/?fusionwindow=settings.php";
    <?php } ?>
    
    $(function(){
        $("#settings_tabs").tabs().css({ 
            "min-height": "400px", 
            "overflow" : "auto" }).show();
    });
</script>
<div id="settings_tabs" class="hide">
<ul>
    <li>
        <a href="#settings_tab_general">
            <i class="fa fa-cog"></i>&nbsp;<?php echo _('General'); ?>
        </a>
    </li>
    <li>
        <a href="#settings_tab_security">
            <i class="fa fa-shield"></i>&nbsp;<?php echo _('Security'); ?>
        </a>
    </li>
    <li>
        <a href="#settings_tab_data_and_polling">
            <i class="fa fa-database"></i>&nbsp;<?php echo _('Data & Polling'); ?>
        </a>
    </li>
    <li>
        <a href="#settings_tab_user_accounts">
            <i class="fa fa-user"></i>&nbsp;<?php echo _('User Accounts'); ?>
        </a>
    </li>
</ul>
    <input name="update"  value="1"  type="hidden"  />
    <div id="settings_tab_general" >
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Program Settings'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td class="vt">
                        <label for="internal_url" >
                            <?php echo _('Internal URL'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="internal_url"  style="width: 300px;"  value="<?php echo $internal_url; ?>"  type="text"  id="internal_url"  class="form-control textfield"  />
                        <div class="subtext">
                            <?php echo _('The default URL used to access Nagios Fusion directly from your internal network.'); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="public_url" >
                            <?php echo _('Public URL'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="public_url"  style="width: 300px;"  type="text"  id="public_url"  class="form-control textfield" value="<?php echo $public_url; ?>" />
                        <div class="subtext">
                            <?php echo _('The URL used to access Nagios Fusion from outside of your internal network (if different than the default above).'); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label for="admin_name" >
                            <?php echo _('Administrator Name'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="admin_name"  placeholder="Nagios Administrator"  value="<?php echo $admin_name; ?>"  type="text"  id="admin_name"  class="form-control textfield"  />
                    </td>
                </tr>
                <tr>
                    <td>
                        <label for="admin_email" >
                            <?php echo _('Administrator Email'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="admin_email"  placeholder="root@localhost"  value="<?php echo $admin_email; ?>"  type="email"  id="admin_email"  class="form-control textfield"  />
                    </td>
                </tr>
                <tr>
                    <td>
                        <label for="default_language" >
                            <?php echo _('Default Language'); ?>:
                        </label>
                    </td>
                    <td>
                        <select name="default_language"  id="default_language"  class="dropdown form-control" >
                            <?php echo get_options_from_array(get_languages_as_array(), $default_language); ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>
                    </td>
                    <td class="checkbox">
                        <label class="checkbox">
                            <input class="inline-checkbox"  id="auto_update_check"  value="1"  name="auto_update_check"  type="checkbox" <?php is_checked($auto_update_check); ?>  />
                            <?php echo _('Automatically check for updates'); ?>
                        </label>
                    </td>
                </tr>
            </table>
        </div>
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Logging Settings'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td class="vt">
                        <label for="log_level" >
                            <?php echo _('Log Level'); ?>:
                        </label>
                    </td>
                    <td>
                        <select name="log_level"  id="log_level"  class="dropdown form-control" >
                            <?php echo get_options_from_array($log_levels, $log_level); ?>
                        </select>
                        <div class="subtext">
                            <?php echo _('The maximum severity of log data to store.'); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="log_file" >
                            <?php echo _('Log File Location'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="log_file"  style="width: 300px;"  value="<?php echo $log_file; ?>"  type="text"  id="log_file"  class="form-control textfield" length="20" />
                        <div class="subtext">
                            <?php echo _('The location on the file system where log data will be written, if enabled.'); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="debug_file" >
                            <?php echo _('Debug File Location'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="debug_file"  style="width: 300px;"  value="<?php echo $debug_file; ?>"  type="text"  id="debug_file"  class="form-control textfield"  />
                        <div class="subtext">
                            <?php echo _('The location on the file system where debug data will be written, if enabled.'); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                    </td>
                    <td class="checkbox">
                        <label class="checkbox">
                            <input value="1"  name="write_log"  type="checkbox" <?php is_checked($write_log); ?> id="write_log"  class="checkbox"  />
                            <?php echo _('Enable writing log data to the specified file'); ?>
                        </label>
                    </td>
                </tr>
                <tr>
                    <td>
                    </td>
                    <td class="checkbox">
                        <label class="checkbox">
                            <input value="1"  name="write_debug"  type="checkbox" <?php is_checked($write_debug); ?> id="write_debug"  class="checkbox"  />
                            <?php echo _('Enable writing debug data to the specified file.'); ?>
                        </label>
                    </td>
                </tr>
                <tr>
                    <td>
                    </td>
                    <td class="checkbox">
                        <label class="checkbox">
                            <input value="1"  name="debug_in_db"  type="checkbox"  id="debug_in_db" <?php is_checked($debug_in_db); ?> class="checkbox"  />
                            <?php echo _('Maintain a copy of the debug data in the') . 
                                        ' <a href="logview.php">Fusion Logs</a> ' . _('database'); ?>
                            <div class="subtext" style="color: red;">
                                <em><?php echo _('This option is only recommended to be enabled for a short time during debugging.'); ?></em>
                            </div>
                        </label>
                    </td>
                </tr>
            </table>
        </div>
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Timezone Settings'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td>
                        <label for="timezone" >
                            <?php echo _('Timezone'); ?>:
                        </label>
                    </td>
                    <td>
                        <select name="timezone"  id="timezone"  class="dropdown form-control" >
                            <?php echo get_options_from_array($timezones, $timezone); ?>
                        </select>
                    </td>
                </tr>
            </table>
        </div>
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Theme Settings'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td>
                        <label for="theme" >
                            <?php echo _('Theme'); ?>:
                        </label>
                    </td>
                    <td>
                        <select name="theme"  id="theme"  class="dropdown form-control" >
                            <?php echo get_options_from_array($themes, $theme); ?>
                        </select>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div id="settings_tab_security" >
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Two Factor Authentication (Email)'); ?>
            </h5>
            <?php
                $two_factor_auth = get_option('two_factor_auth', 0);
                if ($two_factor_auth == 0) {
            ?>
            <div class="alert alert-warning" style="max-width: 700px;">
                <i class="fa fa-exclamation-triangle"></i>
                <?php echo _("Enabling two factor authentication will log all users out of the system and require them to re-login using Two Factor Authentication (Email)."); ?>
                <b><?php echo _("Before enabling, please ensure the system's email configuration is correct and that all users have access to their email accounts."); ?></b>
            </div>
            <?php
                }
            ?>
            <table class="table table-condensed table-no-border table-auto-width">
                    <tr>
                        <td>
                            <label>
                                <?php echo _("Enable Two Factor Auth"); ?>:
                            </label>
                        </td>
                        <td class="checkbox">
                            <label for="two_factor_auth">
                                <input type="checkbox" name="two_factor_auth" id="two_factor_auth" value="1" <?php echo is_checked($two_factor_auth, 1); ?>>
                                <?php echo _("Send an email to users after logging in to authenticate."); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td class="vt">
                            <label for="two_factor_timeout">
                                <?php echo _("Two Factor Token Timeout"); ?>:
                            </label>
                        </td>
                        <td class="form-inline">
                            <div class="input-group">
                                <input type="text" name="two_factor_timeout" id="two_factor_timeout" value="<?php echo intval($two_factor_timeout); ?>" class="form-control" style="width: 50px;">
                                <div class="input-group-addon"><?php echo _("min"); ?></div>
                            </div>
                            <div class="subtext neptune-form-subtext neptune-form-spacer">
                                <?php echo _("Amount of time in minutes that two factor auth tokens should expire."); ?>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label>
                                <?php echo _("Two Factor Cookie"); ?>:
                            </label>
                        </td>
                        <td class="checkbox">
                            <label for="two_factor_cookie">
                                <input type="checkbox" class="checkbox" name="two_factor_cookie" id="two_factor_cookie" value="1" <?php echo is_checked($two_factor_cookie, 1); ?>>
                                <?php echo _("Allow users to choose to remember their computer/browser with a cookie."); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td class="vt">
                            <label for="two_factor_cookie_timeout">
                                <?php echo _("Two Factor Cookie Timeout"); ?>:
                            </label>
                        </td>
                        <td class="form-inline">
                            <div class="input-group">
                                <input type="text" name="two_factor_cookie_timeout" id="two_factor_cookie_timeout" value="<?php echo intval($two_factor_cookie_timeout); ?>" class="form-control" style="width: 50px;">
                                <div class="input-group-addon"><?php echo _("days"); ?></div>
                            </div>
                            <div class="subtext neptune-form-subtext neptune-form-spacer">
                                <?php echo _("Amount of time in days that two factor cookie should expire."); ?>
                            </div>
                        </td>
                    </tr>
                </table>
        </div>
    </div>
    <div id="settings_tab_data_and_polling" >
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Default Interval Settings'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td class="vt">
                        <label for="auth_interval" >
                            <?php echo _('Global Authentication Interval'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="auth_interval"  value="<?php echo $auth_interval; ?>"  size="5"  type="text"  id="auth_interval"  class="form-control textfield"  />
                        <?php echo _('Seconds'); ?>
                        <div class="subtext">
                            <?php echo _('Define the frequency at which the fused servers are checked for authentication.'); ?>
                            <?php e_pop(
                                _('Global Authentication Interval'), 
                                _('Authentication is a single check against the server to ensure both connectivity (information used for polling) and that the specified credentials are still correct. You want to keep this value relatively low. You can override this setting on a per-server basis.')); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="polling_interval" >
                            <?php echo _('Global Polling Interval'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="polling_interval"  value="<?php echo $polling_interval; ?>"  size="5"  type="text"  id="polling_interval"  class="form-control textfield"  />
                        <?php echo _('Seconds'); ?>
                        <div class="subtext">
                            <?php echo _('Define the frequency at which the fused servers are polled for data.'); ?>
                            <?php e_pop(
                                _('Global Polling Interval'), 
                                _("Larger systems may be able to benefit from a larger number here. You can always override this setting on a per-server basis, as well.")); ?>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Polling Configuration'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td>
                        <label for="poll_subsys_memory_limit" >
                            <?php echo _('Mapped User Polling'); ?>:
                        </label>
                    </td>
                    <td class="checkbox">
                        <label class="checkbox">
                            <input type="checkbox" name="only_poll_logged_in" value="1" <?php echo is_checked($only_poll_logged_in, 1); ?> id="only_poll_logged_in" class="checbbox">
                            <?php echo _('Only poll data for mapped users when a user is logged in'); ?>
                        </label>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="poll_subsys_memory_limit" >
                            <?php echo _('Polling Subsystem Memory Limit'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="poll_subsys_memory_limit"  value="<?php echo $poll_subsys_memory_limit; ?>"  size="5"  type="text"  id="poll_subsys_memory_limit"  class="form-control textfield"  />
                        <div class="subtext">
                            <?php echo _('The maximum amount of memory that a poller may consume while running.'); ?>
                            <?php e_pop(
                                _('Polling Subsystem Memory Limit'),
                                _("This is same value that would be accepted by php.memory_limit. Acceptable values are things such as '128M', '1G', for 128 Megabytes and 1 Gigabyte respectively, along with '-1' for allowing unlimited memory. If you're connecting to large systems, you may want to keep this value high.")); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="simultaneous_pollers" >
                            <?php echo _('Simultaneous Pollers'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="simultaneous_pollers"  value="<?php echo $simultaneous_pollers; ?>"  size="5"  type="text"  id="simultaneous_pollers"  class="form-control textfield"  />
                        <?php echo _('Pollers'); ?>
                        <div class="subtext">
                            <?php echo _('The maximum number of pollers that Fusion can spawn to grab data.'); ?>
                            <?php e_pop(
                                _('Simultaneous Pollers'),
                                _("1 poller should be sufficient for a few XI or Core servers with a moderate amount of checks each (about 2000 checks per server). However, if you're connecting to at least one large system, you'll want to increase this value so that the polling subsystem doesn't get choked waiting on a large batch of API calls. A decent formula in that case would be at least one poller for every fused server.")); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="live_data_timeout" >
                            <?php echo _('Live Data Timeout'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="live_data_timeout"  value="<?php echo $live_data_timeout; ?>"  size="5"  type="text"  id="live_data_timeout"  class="form-control textfield"  />
                        <?php echo _('Seconds'); ?>
                        <div class="subtext">
                            <?php echo _('The length of time that Fusion waits for a chunk of data from a fused server before timing out.'); ?>
                            <?php e_pop(
                                _('Live Data Timeout'),
                                _("This is the timeout value for each individual API call made to a fused server. This can be kept relatively low unless you are connected to a large Nagios Core install.")); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="polling_lock_stale_threshhold" >
                            <?php echo _('Polling Lock Max Age'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="polling_lock_stale_threshhold"  value="<?php echo $polling_lock_stale_threshhold; ?>"  size="5"  type="text"  id="polling_lock_stale_threshhold"  class="form-control textfield"  />
                        <?php echo _('Seconds'); ?>
                        <div class="subtext">
                            <?php echo _('The maximum amount of time that a poller can take while grabbing data from a fused server.'); ?>
                            <?php e_pop(
                                _('Polling Lock Max Age'),
                                _("If something goes wrong with a poller, and it isn't able to remove the lock on the fused server it's grabbing data from, then this is the amount of time that the subsystem will wait before it spawns a new poller.")); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="vt">
                        <label for="poll_record_count" >
                            <?php echo _('Poll Record Count'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="poll_record_count"  value="<?php echo $poll_record_count; ?>"  size="5"  type="text"  id="poll_record_count"  class="form-control textfield"  />
                        <?php echo _('Records'); ?>
                        <div class="subtext">
                            <?php echo _('The number of records to grab in a single API call to a fused server.'); ?>
                            <?php e_pop(
                                _('Poll Record Count'),
                                _("When fusion polls the data, it calls the API and grabs only a handful of records at a time. This is the value you set to determine the amount of records it grabs. If you don't have any fused servers that are large systems, then you can actually keep this number very high.")); ?>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('Database Retention Settings'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td class="vt">
                        <label for="log_retention" >
                            <?php echo _('Log Data Retention'); ?>:
                        </label>
                    </td>
                    <td>
                        <input name="log_retention"  value="<?php echo $log_retention; ?>"  size="5"  type="text"  id="log_retention"  class="form-control textfield"  />
                        <?php echo _('Days'); ?>
                        <div class="subtext">
                            <?php echo _('The maximum amount of time to retain log data in the database.'); ?>
                            <?php e_pop(
                                _('Database Retention Settings'),
                                _("If you have debug data being written to the database, you'll want to keep this value as low as 1 or 2 days while that's enabled. Having the log data in the database allows for a nice interface where you can view recent logs, but this is not meant as a replacement for the log file.")); ?>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div id="settings_tab_user_accounts" >
        <div class="formbuilder-div formbuilder" >
            <h5 class="ul" >
                <?php echo _('New User Account Information Email'); ?>
            </h5>
            <table class="formbuilder-table formbuilder" >
                <tr>
                    <td style="width: 80px;"><label><?php echo _('Subject'); ?>:</label></td>
                    <td><input type="text" class="form-control" name="user_new_account_email_subject" style="width: 300px;" value="<?php echo encode_form_val($user_new_account_email_subject); ?>"></td>
                </tr>
                <tr>
                    <td><label><?php echo _('Body Text'); ?>:</label></td>
                    <td>
                        <textarea name="user_new_account_email_body" style="width: 50%; min-width: 400px; height: 120px;" class="form-control"><?php echo encode_form_val($user_new_account_email_body); ?></textarea>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>
    <div class="clear"></div>
    <div class="formbuilder-buttons">
        <input name="submit"  value="<?php echo _('Update Settings'); ?>"  class="btn btn-primary btn-sm"  type="submit"  />
        <input name="cancel"  value="<?php echo _('Cancel'); ?>"  class="btn btn-default btn-sm cancel-validator"  type="submit"  />
    </div>
</form>
<?php
}
