<?php
//
//	Nagios Fusion 4 REST API v1
//  Copyright (c) 2018 Nagios Enterprises, LLC. All rights reserved.
//
define('API', true);

require_once('../includes/utils.inc.php');
require_once('../includes/utils-api.inc.php');
require_once(dirname(__FILE__) . '/../../includes/base.inc.php');

function init_api() {
    // Requests from the same server don't have a HTTP_ORIGIN header
    if (!array_key_exists('HTTP_ORIGIN', $_SERVER)) {
        $_SERVER['HTTP_ORIGIN'] = $_SERVER['SERVER_NAME'];
    }

    header("Access-Control-Allow-Orgin: *");
    header("Access-Control-Allow-Methods: *");

    if (array_key_exists('outputtype', $_GET)) {
        if ($_GET['outputtype'] == 'xml') {
            $_GET['pretty'] = 0;
            header("Content-Type: application/xml");
        } else {
            header("Content-Type: application/json");
        }
    } else {
        header("Content-Type: application/json");
    }

    try {
        $api = new API($_REQUEST['request'], $_SERVER['HTTP_ORIGIN']);
        echo $api->process_api();
    } catch (Exception $e) {
        echo json_encode(Array('error' => $e->getMessage())) . "\n";
    }
}