<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');

print_dashboard();

function print_dashboard() {
    $dashboard_id = intval(grab_request_var('id', 0));
    
    $dashboard = get_dashboard($dashboard_id);
    if ($dashboard === false) {

        // if the dashboard was invalid, just grab a dashboard for the user
        $dashboards = get_dashboards(0, $screen = 0);
        if (count($dashboards) > 0) {
            foreach ($dashboards as $this_dashboard) {
                $dashboard_id = $this_dashboard['dashboard_id'];
                $dashboard = $this_dashboard;
                break;
            }
        } else {

            // if we don't have any, we should probably make some
            header("location: manage.php");
            exit();
        }
    }

    $theme = get_theme();
    $default_bgcolor = "FFF";
    if ($theme == 'modern-dark') {
        $default_bgcolor = "111";
    }

    $opts = array('body_style' => 'background-color: ' . $default_bgcolor . ';',
                  'body_class' => 'dashboard-no-pad');

    // Get dashboard background color for body style
    $bgcolor = grab_array_var($dashboard, 'bgcolor');
    if (!empty($bgcolor)) {
        $opts['body_style'] = 'background-color: #'.$bgcolor.';';
    }

    $page_title = $dashboard['dashboard_name'];
    child_page($page_title, $opts);

    echo get_dashboard_html($dashboard, true);
}
