<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');

show_available_dashlets();

function show_available_dashlets() {

    global $dashlets;

    $page_title = _('Available Dashlets');

    child_page($page_title);
    echo well_top_page_header($page_title);

    echo '<p>' . _('The following dashlets can be added to any one or more of your dashboards.');

    if (is_admin())
        echo sprintf(_('%sNeed a custom dashlet created for your organization? No problem! %sContact us%s for pricing information.'), '<br />', '<a href="https://www.nagios.com/contact/" target="_blank">' , '</a>');

    echo '</p>';

    echo '<br />';
    echo '<br />';

    foreach ($dashlets as $dashlet) {

        // Ignore the test dashlet we use as an example
        if (isset($dashlet[DASHLET_NAME]) && $dashlet[DASHLET_NAME] != 'Test')
            echo get_dashlet_preview($dashlet);
    }
}
