<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');

print_home_dashboard();

// get the first home dashboard we find and display it
// or flash an error message and go to the static home page
function print_home_dashboard() {

    $dashboards = get_dashboards($user_id = 0, $screen = null, $home = 1);
    if (count($dashboards) > 0) {
        foreach ($dashboards as $dashboard) {

            $opts = array(
                'body_style' => 'background-color: #ffffff;',
                'body_class' => 'dashboard-no-pad',
                );

            $page_title = $dashboard['dashboard_name'];
            if (!empty($dashboard['bgcolor']))
                $opts['body_style'] = 'background-color: #' . $dashboard['bgcolor'] . ';';

            child_page($page_title, $opts);
            echo get_dashboard_html($dashboard);
            exit();

        }
    } else {

        flash_message(
            _("It appears that you don't have any home dashboards. Try logging out, and then back in. If that doesn't resolve the issue, please contact your systems administrator"), 
            'error'
            );

        header("location: " . get_base_url(false) . "main.php");
    }
}