<?php
//
// Nagios Fusion API Documentation
// Copyright (c) 2008-2017 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../includes/base.inc.php');
require_once(dirname(__FILE__) . '/html-helpers.inc.php');

// Initialization stuff
init_session();

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_authentication(false);

if (!is_admin()) {
    die(_('Not authorized to view this page.'));
}

route_request();

function route_request()
{
    $page = grab_request_var("page", "");

    switch ($page) {
        default:
            show_main_api_page();
            break;
    }
}

function show_main_api_page()
{
    $title = _("REST API - System Reference");
    $apikey = get_user_attr('api_key');

    child_page($title);
?>

    <!-- Keep the help section part of the page -->
    <script src="../includes/js/clipboard.min.js"></script>
    <script>
    $(document).ready(function() {
        resize_nav();
        new Clipboard('.copy');
        $(window).resize(function() {
            resize_nav();
        });
    });

    function resize_nav() {
        var width = $('.nav-box').width();
        $('.help-right-nav').css('width', width);
    }
    </script>

    <div class="container-fluid help">
        <div class="row">
            <div class="col-sm-8 col-md-9 col-lg-9">

                <h1><?php echo _('REST API - System Reference'); ?></h1>
                <p><?php echo _('The system section of the API allows management of the system, users, and fused servers.'); ?> <em><?php echo _('This API section is'); ?> <b><?php echo _('admin only'); ?></b>.</em></p>

                <h3 class="help-section-head"><?php echo _('Basic System'); ?></h3>

                <div class="help-section obj-reference">
                    <a name="system-status"></a>
                    <h4>GET system/status</h4>
                    <p><?php echo _('Gives the output of the current system status.'); ?></p>
                    <div>
                        <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-status"><?php echo _('Copy'); ?></a></h6>
                        <pre class="curl-request"><code id="cmd-system-status">curl -XGET "<?php echo get_base_url(); ?>api/v1/system/status?apikey=<?php echo $apikey; ?>&amp;pretty=1"</code></pre> <a href="<?php echo get_base_url(); ?>api/v1/system/status?apikey=<?php echo $apikey; ?>&amp;pretty=1" target="_blank" rel="noreferrer" class="api-popout tt-bind" title="<?php echo _('Open URL in browser window'); ?>"><i class="fa fa-share icon-large"></i></a>
                        <div class="clear"></div>
                    </div>
                    <h6><?php echo _('Response JSON'); ?>:</h6>
                    <pre>{
    "load": {
        "load1": "0.33",
        "load5": "0.32",
        "load15": "0.27"
    },
    "memory": {
        "total": "3774",
        "used": "1620",
        "free": "242",
        "shared": "184",
        "buffers": "1911",
        "cached": "1617"
    },
    "swap": {
        "total": "2559",
        "used": "578",
        "free": "1981"
    },
    "cpu": {
        "user": "7.15",
        "nice": "0.00",
        "system": "1.42",
        "iowait": "0.30",
        "steal": "0.00",
        "idle": "91.13"
    }
}</pre>

                <h3 class="help-section-head"><?php echo _('Fused Server Management'); ?></h3>

                <div class="help-section obj-reference">
                    <a name="system-fused-servers"></a>
                    <h4>GET system/servers</h4>
                    <p><?php echo _('Get a list of currently fused servers.'); ?></p>
                    <div>
                        <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-fused-servers"><?php echo _('Copy'); ?></a></h6>
                        <pre class="curl-request"><code id="cmd-system-fused-servers">curl -XGET "<?php echo get_base_url(); ?>api/v1/system/servers?apikey=<?php echo $apikey; ?>&amp;pretty=1"</code></pre>
                        <div class="clear"></div>
                    </div>
                    <div>
                        <h6><?php echo _('Example Repsonse (Success)'); ?></h6>
                        <pre>{
    "records": 3,
    "servers": [
        {
            "server_id": "1",
            "name": "Test XI",
            "address": "http:\/\/192.168.0.1\/nagiosxi"
        },
        {
            "server_id": "2",
            "name": "Example Log Server",
            "address": "http:\/\/192.168.0.2\/nagioslogserver\/"
        },
        {
            "server_id": "3",
            "name": "Example XI",
            "address": "http:\/\/192.168.0.3\/nagiosxi\/"
        }
    ]
}
</pre>
                    <div class="clear"></div>
                </div>
            </div>

                <div class="help-section obj-reference">
                    <a name="system-fused-server"></a>
                    <h4>GET system/server</h4>
                    <div class="container-fluid" style="padding: 0 5px;">
                        <div class="row">
                            <div class="col-md-5 col-lg-4 col-xl-3">
                                <p><?php echo _('Get detailed information about specified fused server.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Required Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>server_id</td>
                                            <td>server id</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-7 col-lg-8 col-xl-9">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-fused-server"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-fused-server">curl -XGET "<?php echo get_base_url(); ?>api/v1/system/server?apikey=<?php echo $apikey; ?>&amp;pretty=1&amp;<b>server_id=1</b>"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "server_info": {
        "server_id": "1",
        "name": "Test XI",
        "server_type": "Nagios XI",
        "authentication_type": "Fusekey",
        "url": "http:\/\/192.168.0.1\/nagiosxi",
        "cgi_bin": "",
        "location": "",
        "notes": "",
        "username": "nagiosadmin",
        "last_auth_time": "2018-01-19 12:38:38",
        "polling_interval": "0",
        "timezone": "America\/Chicago"
    }
}
</pre>
                                <h6><?php echo _('Response (Failure)'); ?>:</h6>
                                <pre>{
    "error": "No server with an ID of 1 was found. Please ensure you have the correct ID and resubmit your request."
}
</pre>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="help-section obj-reference">
                    <a name="system-add-fuse-server"></a>
                    <h4>POST system/server</h4>
                    <div class="container-fluid" style="padding: 0 5px;">
                        <div class="row">
                            <div class="col-md-6 col-lg-6 col-xl-5">
                                <p><?php echo _('Adds a fused server to the Nagios Fusion system. Values in <b>bold</b> are defaults.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                            <th><?php echo _('Values'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>server_name</td>
                                            <td>string</td>
                                            <td>server name</td>
                                        </tr>
                                        <tr>
                                            <td>server_type</td>
                                            <td>string</td>
                                            <td>xi, core, or nls</td>
                                        </tr>
                                        <tr>
                                            <td>url</td>
                                            <td>string</td>
                                            <td>full url of server to be fused</td>
                                        </tr>
                                        <tr>
                                            <td>username</td>
                                            <td>string</td>
                                            <td>user name</td>
                                        </tr>
                                        <tr>
                                            <td>password</td>
                                            <td>string</td>
                                            <td>password</td>
                                        </tr>
                                        <tr>
                                            <td>fusekey</td>
                                            <td>string</td>
                                            <td>fusekey</td>
                                        </tr>
                                        <tr>
                                            <td>enabled</td>
                                            <td>integer</td>
                                            <td>0 (disabled) or <b>1</b> (enabled)</td>
                                        </tr>
                                        <tr>
                                            <td>auth_type</td>
                                            <td>integer</td>
                                            <td>
                                                <b>0 - Fusekey Auth</b><br>
                                                1 - Session Auth<br>
                                                2 - Basic Auth<br>
                                                3 - API Auth
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>auth_interval</td>
                                            <td>integer</td>
                                            <td><b>Fusion default</b> or seconds</td>
                                        </tr>
                                        <tr>
                                            <td>polling_interval</td>
                                            <td>integer</td>
                                            <td><b>Fusion default</b> or seconds</td>
                                        </tr>
                                        <tr>
                                            <td>cgi_bin</td>
                                            <td>string</td>
                                            <td>file path to cgi_bin</td>
                                        </tr>
                                        <tr>
                                            <td>ssl_hostname_verify</td>
                                            <td>integer</td>
                                            <td><b>0</b> (disabled) or 1 (enabled)</td>
                                        </tr>
                                        <tr>
                                            <td>location</td>
                                            <td>string</td>
                                            <td>location</td>
                                        </tr>
                                        <tr>
                                            <td>timezone</td>
                                            <td>string</td>
                                            <td><b>Fusion default</b> or &lt;timezone&gt;</td>
                                        </tr>
                                        <tr>
                                            <td>notes</td>
                                            <td>string</td>
                                            <td>notes</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-7">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-add-fuse-server"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-add-fuse-server">curl -XPOST "<?php echo get_base_url(); ?>api/v1/system/server?apikey=<?php echo $apikey; ?>" -d "server_name=examplexi&server_type=xi&url=http://192.168.0.1/nagiosxi&fusekey={FUSEKEY}&username=nagiosadmin&password=example"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "success": "<?php echo _('Server successfully added with an ID of 4'); ?>"
}</pre>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="help-section obj-reference">
                    <a name="system-delete-fused-server"></a>
                    <h4>DELETE system/server/<b>&lt;server_id&gt;</b></h4>
                    <div class="container-fluid" style="padding: 0 5px;">
                        <div class="row">
                            <div class="col-md-5 col-lg-4 col-xl-3">
                                <p><?php echo _('Deletes a fused server from the Nagios Fusion system.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Required Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>server_id</td>
                                            <td>integer</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-7 col-lg-8 col-xl-9">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-delete-fused-server"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-delete-fused-server">curl -XDELETE "<?php echo get_base_url(); ?>api/v1/system/server/<b>4</b>?apikey=<?php echo $apikey; ?>&amp;pretty=1"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "success": "Server with ID of 4 successfully removed."
}                               </pre>
                                <h6><?php echo _('Response (Failure)'); ?>:</h6>
                                <pre>{
    "success": "Server was not removed. Please ensure a valid server ID was specified and resubmit your request."
}                               </pre>
                            </div>
                        </div>
                    </div>
                </div>

                <h3 class="help-section-head"><?php echo _('Users'); ?></h3>

                <div class="help-section obj-reference">
                    <a name="users"></a>
                    <h4>GET system/users</h4>
                    <p><?php echo _('Lists all users in the Nagios Fusion system.'); ?></p>
                    <div>
                        <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-users"><?php echo _('Copy'); ?></a></h6>
                        <pre class="curl-request"><code id="cmd-system-users">curl -XGET "<?php echo get_base_url(); ?>api/v1/system/users?apikey=<?php echo $apikey; ?>&amp;pretty=1"</code></pre> <a href="<?php echo get_base_url(); ?>api/v1/system/users?apikey=<?php echo $apikey; ?>&amp;pretty=1" target="_blank" rel="noreferrer" class="api-popout tt-bind" title="<?php echo _('Open URL in browser window'); ?>"><i class="fa fa-share icon-large"></i></a>
                        <div class="clear"></div>
                    </div>
                    <h6><?php echo _('Response JSON'); ?>:</h6>
                    <pre>{
    "records": 4,
    "users": [
        {
            "user_id": "1",
            "username": "nagiosadmin"
        },
        {
            "user_id": "2",
            "username": "user2"
        },
        {
            "user_id": "3",
            "username": "user3"
        },
        {
            "user_id": "4",
            "username": "user4"
        }
    ]
}</pre>
                </div>

                <div class="help-section obj-reference">
                    <a name="user"></a>
                    <h4>GET system/user</h4>
                    <div class="row">
                            <div class="col-md-5 col-lg-4 col-xl-3">
                                <p><?php echo _('List detailed information for a specified user.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Required Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>user_id</td>
                                            <td>user id</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-7 col-lg-8 col-xl-9">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-user"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-user">curl -XGET "<?php echo get_base_url(); ?>api/v1/system/user?apikey=<?php echo $apikey; ?>&amp;<b>user_id=1</b>&amp;pretty=1"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "user_info": [
        {
            "user_id": "1",
            "username": "nagiosadmin",
            "name": "Nagios Administrator",
            "email": "root@localhost",
            "level": "admin",
            "enabled": "1",
            "times_logged_in": "56",
            "api_enabled": "0",
            "recent_login_failures": "0",
            "account_locked": "0",
            "last_login_time": "0000-00-00 00:00:00"
        }
    ]
}
</pre>
                                <h6><?php echo _('Response (Failure)'); ?>:</h6>
                                <pre>{
    "error": "No user was found with the supplied ID. Please ensure you have the correct ID and resubmit your request."
}
</pre>
                            </div>
                        </div>
                </div>

                <div class="help-section obj-reference">
                    <a name="add-user"></a>
                    <h4>POST system/user</h4>
                    <div class="container-fluid" style="padding: 0 5px;">
                        <div class="row">
                            <div class="col-md-6 col-lg-6 col-xl-5">
                                <p><?php echo _('Creates a new user in the Nagios Fusion system. Values in <b>bold</b> are defaults.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                            <th><?php echo _('Values'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>username</td>
                                            <td>string</td>
                                            <td>user name</td>
                                        </tr>
                                        <tr>
                                            <td>password</td>
                                            <td>string</td>
                                            <td>password</td>
                                        </tr>
                                        <tr>
                                            <td>name</td>
                                            <td>string</td>
                                            <td>name</td>
                                        </tr>
                                        <tr>
                                            <td>email</td>
                                            <td>string</td>
                                            <td>email address</td>
                                        </tr>
                                        <tr>
                                            <td>force_pw_change</td>
                                            <td>integer</td>
                                            <td><b>1</b> or 0</td>
                                        </tr>
                                        <tr>
                                            <td>email_info</td>
                                            <td>integer</td>
                                            <td><b>1</b> or 0</td>
                                        </tr>
                                        <tr>
                                            <td>language</td>
                                            <td>string</td>
                                            <td><b>Fusion default</b> or &lt;language&gt;</td>
                                        </tr>
                                        <tr>
                                            <td>date_format</td>
                                            <td>integer</td>
                                            <td>
                                                <b>1 - YYYY-MM-DD</b><br>
                                                2 - MM/DD/YYYY<br>
                                                3 - DD/MM/YYYY
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>number_format</td>
                                            <td>integer</td>
                                            <td>
                                                1 - 1000.00<br>
                                                <b>2 - 1,000.00</b><br>
                                                3 - 1.000,00<br>
                                                4 - 1 000.00<br>
                                                5 - 1'000.00
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>auth_level</td>
                                            <td>string</td>
                                            <td><b><?php echo _('user'); ?></b> <?php echo _('or admin'); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3"><?php echo _('If user type selected: (Ignored if user is admin)'); ?></td>
                                        </tr>
                                        <tr>
                                            <td>read_only</td>
                                            <td>integer</td>
                                            <td><b>0</b> or 1 (<?php echo _("all others won't work"); ?>)</td>
                                        </tr>
                                        <tr>
                                            <td colspan="3"><?php echo _('Auth settings for using AD or LDAP'); ?></td>
                                        </tr>
                                        <tr>
                                            <td>auth_type</td>
                                            <td>string</td>
                                            <td><b>local</b>, ad, ldap</td>
                                        </tr>
                                        <tr>
                                            <td>auth_server_id</td>
                                            <td>string</td>
                                            <td><?php echo _('Auth server ID'); ?></td>
                                        </tr>
                                        <tr>
                                            <td>allow_local</td>
                                            <td>integer</td>
                                            <td><b>0</b> or 1</td>
                                        </tr>
                                        <tr>
                                            <td>ad_username</td>
                                            <td>string</td>
                                            <td><?php echo _('AD username without suffix'); ?></td>
                                        </tr>
                                        <tr>
                                            <td>ldap_dn</td>
                                            <td>string</td>
                                            <td><?php echo _('LDAP full distinguished name'); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-7">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-add-user"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-add-user">curl -XPOST "<?php echo get_base_url(); ?>api/v1/system/user?apikey=<?php echo $apikey; ?>&amp;pretty=1" -d "username=jmcdouglas&amp;password=test&amp;name=Jordan%20McDouglas&amp;email=jmcdouglas@localhost"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "success": "<?php echo _('User account jmcdouglas was added successfully!'); ?>",
    "user_id": "2"
}</pre>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="help-section obj-reference">
                    <a name="delete-user"></a>
                    <h4>DELETE system/user</h4>
                    <div class="container-fluid" style="padding: 0 5px;">
                        <div class="row">
                            <div class="col-md-5 col-lg-4 col-xl-3">
                                <p><?php echo _('Deletes a user from the Nagios Fusion system.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Required Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>user_id</td>
                                            <td>integer</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-7 col-lg-8 col-xl-9">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-delete-user"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-delete-user">curl -XDELETE "<?php echo get_base_url(); ?>api/v1/system/user/<b>2</b>?apikey=<?php echo $apikey; ?>&amp;pretty=1"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "success": "User successfully deleted."
}                               </pre>
                                <h6><?php echo _('Response (Failure)'); ?>:</h6>
                                <pre>{
    "success": "User with ID 2 does not exist."
}                               </pre>
                            </div>
                        </div>
                    </div>
                </div>

                <h3 class="help-section-head"><?php echo _('Auth Servers'); ?></h3>

                <div class="help-section obj-reference">
                    <a name="auth-server"></a>
                    <h4>GET system/authserver</h4>
                    <p><?php echo _('Get a list of auth servers. You can filter this list by <b>server_id</b> by passing it through as a URL parameter.'); ?></p>
                    <div>
                        <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-authserver"><?php echo _('Copy'); ?></a></h6>
                        <pre class="curl-request"><code id="cmd-system-authserver">curl -XGET "<?php echo get_base_url(); ?>api/v1/system/authserver?apikey=<?php echo $apikey; ?>&amp;pretty=1"</code></pre> <a href="<?php echo get_base_url(); ?>api/v1/system/authserver?apikey=<?php echo $apikey; ?>&amp;pretty=1" target="_blank" rel="noreferrer" class="api-popout tt-bind" title="<?php echo _('Open URL in browser window'); ?>"><i class="fa fa-share icon-large"></i></a>
                        <div class="clear"></div>
                    </div>
                    <h6><?php echo _('Response JSON'); ?>:</h6>
                    <pre>{
    "records": 1,
    "authservers": [
        {
            "id": "59bd9f6f67775",
            "enabled": 1,
            "conn_method": "ad",
            "ad_account_suffix": "@not.nagios.local",
            "ad_domain_controllers": "dc1.not.nagios.local",
            "base_dn": "dc=not,dc=nagios,dc=local",
            "security_level": "none",
            "ldap_port": "",
            "ldap_host": ""
        }
    ]
}</pre>
                </div>

                <div class="help-section obj-reference">
                    <a name="add-auth-server"></a>
                    <h4>POST system/authserver</h4>
                    <div class="container-fluid" style="padding: 0 5px;">
                        <div class="row">
                            <div class="col-md-6 col-lg-6 col-xl-5">
                                <p><?php echo _('Creates a new auth server in the Nagios Fusion system. Values in <b>bold</b> are defaults.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                            <th><?php echo _('Values'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>conn_method</td>
                                            <td>string</td>
                                            <td>ad or ldap</td>
                                        </tr>
                                        <tr>
                                            <td>enabled</td>
                                            <td>integer</td>
                                            <td><b>1</b> or 0</td>
                                        </tr>
                                        <tr>
                                            <td>base_dn</td>
                                            <td>string</td>
                                            <td><?php echo _('full distinguished name'); ?></td>
                                        </tr>
                                        <tr>
                                            <td>security_level</td>
                                            <td>string</td>
                                            <td><b>none</b>, ssl, tls</td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">conn_method=ldap</td>
                                        </tr>
                                        <tr>
                                            <td>ldap_host</td>
                                            <td>string</td>
                                            <td>ip address or hostname</td>
                                        </tr>
                                        <tr>
                                            <td>ldap_port</td>
                                            <td>integer</td>
                                            <td><b>389</b> <?php echo _('or port number'); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">conn_method=ad</td>
                                        </tr>
                                        <tr>
                                            <td>ad_account_suffix</td>
                                            <td>string</td>
                                            <td><?php echo _('account suffix'); ?> (ex: @domain)</td>
                                        </tr>
                                        <tr>
                                            <td>ad_domain_controllers</td>
                                            <td>string</td>
                                            <td><?php echo _('comma separated list of domain controllers'); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-7">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-add-authserver"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-add-authserver">curl -XPOST "<?php echo get_base_url(); ?>api/v1/system/authserver?apikey=<?php echo $apikey; ?>&amp;pretty=1" -d "conn_method=ldap&amp;ldap_host=192.168.0.123&amp;base_dn=dc%3Dnagios,dc%3Dlocal&amp;security_level=ssl"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "success": "Auth server created successfully.",
    "server_id": "59bdbea68f924"
}
</pre>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="help-section obj-reference">
                    <a name="delete-auth-server"></a>
                    <h4>DELETE system/authserver/&lt;server_id&gt;</h4>
                    <div class="container-fluid" style="padding: 0 5px;">
                        <div class="row">
                            <div class="col-md-5 col-lg-4 col-xl-3">
                                <p><?php echo _('Deletes an auth server from the Nagios Fusion system.'); ?></p>
                                <table class="table table-condensed table-bordered table-hover" style="margin-bottom: 10px;">
                                    <thead>
                                        <tr>
                                            <th><?php echo _('Required Parameters'); ?></th>
                                            <th><?php echo _('Value Type'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>server_id</td>
                                            <td>integer</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-7 col-lg-8 col-xl-9">
                                <h6><?php echo _('Example cURL Request'); ?>: <a class="copy fr" data-clipboard-target="#cmd-system-delete-authserver"><?php echo _('Copy'); ?></a></h6>
                                <pre><code id="cmd-system-delete-authserver">curl -XDELETE "<?php echo get_base_url(); ?>api/v1/system/authserver/<b>59bdbea68f924</b>?apikey=<?php echo $apikey; ?>&amp;pretty=1"</code></pre>
                                <h6><?php echo _('Response (Success)'); ?>:</h6>
                                <pre>{
    "success": "Removed auth server successfully."
}
</pre>
                            </div>
                        </div>
                    </div>
                </div>
                </div>
             </div>
             <div class="col-sm-4 col-md-3 col-lg-3 nav-box">
                <div class="well help-right-nav">
                    <h5><?php echo _('REST API - System Reference'); ?></h5>
                    <p style="margin: 10px 0; padding: 0;"><?php echo _('Basic System'); ?></p>
                    <ul>
                        <li><a href="#system-status"><?php echo _('GET system/status'); ?></a></li>
                    </ul>
                    <p style="margin: 10px 0; padding: 0;"><?php echo _('Fused Server Management'); ?></p>
                    <ul>
                        <li><a href="#system-fused-servers"><?php echo _('GET system/servers'); ?></a></li>
                        <li><a href="#system-fused-server"><?php echo _('GET system/server'); ?></a></li>
                        <li><a href="#system-add-fuse-server"><?php echo _('POST system/server'); ?></a></li>
                        <li><a href="#system-delete-fused-server"><?php echo _('DELETE system/server/&lt;server_id&gt;'); ?></a></li>
                    </ul>
                    <p style="margin: 10px 0; padding: 0;"><?php echo _('Users'); ?></p>
                    <ul>
                        <li><a href="#users"><?php echo 'GET system/users'; ?></a></li>
                        <li><a href="#user"><?php echo 'GET system/user'; ?></a></li>
                        <li><a href="#add-user"><?php echo 'POST system/user'; ?></a></li>
                        <li><a href="#delete-user"><?php echo 'DELETE system/user/&lt;user_id&gt;'; ?></a></li>
                    </ul>
                    <p style="margin: 10px 0; padding: 0;"><?php echo _('Auth Servers'); ?></p>
                    <ul>
                        <li><a href="#auth-server"><?php echo 'GET system/authserver'; ?></a></li>
                        <li><a href="#add-auth-server"><?php echo 'POST system/authserver'; ?></a></li>
                        <li><a href="#delete-auth-server"><?php echo 'DELETE system/authserver/&lt;server_id&gt;'; ?></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

<?php
}
?>